/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class BarMagnet
extends AbstractMagnet {
    private static final Dimension INTERNAL_GRID_SIZE = new Dimension(26, 6);
    private static final Dimension EXTERNAL_NEAR_GRID_SIZE = new Dimension(101, 81);
    private static final Dimension EXTERNAL_FAR_GRID_SIZE = new Dimension(126, 61);
    private final Grid internalGrid = new Grid("bfield/BX_internal.csv", "bfield/BY_internal.csv", INTERNAL_GRID_SIZE, 5.0);
    private final Grid externalNearGrid = new Grid("bfield/BX_external_near.csv", "bfield/BY_external_near.csv", EXTERNAL_NEAR_GRID_SIZE, 5.0);
    private final Grid externalFarGrid = new Grid("bfield/BX_external_far.csv", "bfield/BY_external_far.csv", EXTERNAL_FAR_GRID_SIZE, 20.0);

    protected Vector2D getBFieldRelative(Point2D point2D, Vector2D vector2D) {
        assert (point2D != null);
        assert (vector2D != null);
        double d = this.getBx(point2D.getX(), point2D.getY());
        double d2 = this.getBy(point2D.getX(), point2D.getY());
        vector2D.setComponents(d, d2);
        vector2D.scale(this.getStrength() / 1.0);
        return vector2D;
    }

    private double getBx(double d, double d2) {
        Grid grid = this.chooseGrid(d, d2);
        return this.interpolate(Math.abs(d), Math.abs(d2), grid.getMaxX(), grid.getMaxY(), grid.getBxArray(), grid.getSpacing());
    }

    private double getBy(double d, double d2) {
        Grid grid = this.chooseGrid(d, d2);
        double d3 = this.interpolate(Math.abs(d), Math.abs(d2), grid.getMaxX(), grid.getMaxY(), grid.getByArray(), grid.getSpacing());
        if (d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0) {
            d3 *= -1.0;
        }
        return d3;
    }

    private Grid chooseGrid(double d, double d2) {
        Grid grid = null;
        grid = this.internalGrid.contains(d, d2) ? this.internalGrid : (this.externalNearGrid.contains(d, d2) ? this.externalNearGrid : this.externalFarGrid);
        return grid;
    }

    private double interpolate(double d, double d2, double d3, double d4, double[][] dArray, double d5) {
        if (!(d >= 0.0) || !(d2 >= 0.0)) {
            throw new IllegalArgumentException("x and y must be positive");
        }
        double d6 = 0.0;
        if (d >= 0.0 && d <= d3 && d2 >= 0.0 && d2 <= d4) {
            int n = (int)(d / d5);
            int n2 = (int)(d2 / d5);
            if (n == dArray.length - 1) {
                --n;
            }
            if (n2 == dArray[0].length - 1) {
                --n2;
            }
            double d7 = (double)n * d5;
            double d8 = d7 + d5;
            double d9 = (double)n2 * d5;
            double d10 = d9 + d5;
            double d11 = dArray[n][n2];
            double d12 = dArray[n + 1][n2];
            double d13 = dArray[n][n2 + 1];
            double d14 = dArray[n + 1][n2 + 1];
            d6 = d11 * ((d8 - d) / (d8 - d7)) * ((d10 - d2) / (d10 - d9)) + d12 * ((d - d7) / (d8 - d7)) * ((d10 - d2) / (d10 - d9)) + d13 * ((d8 - d) / (d8 - d7)) * ((d2 - d9) / (d10 - d9)) + d14 * ((d - d7) / (d8 - d7)) * ((d2 - d9) / (d10 - d9));
        }
        return d6;
    }

    private static class Grid {
        private final double[][] bxArray;
        private final double[][] byArray;
        private final Dimension size;
        private final double spacing;

        public Grid(String string, String string2, Dimension dimension, double d) {
            this.size = new Dimension(dimension.width, dimension.height);
            this.spacing = d;
            this.bxArray = this.readComponent(string, dimension);
            this.byArray = this.readComponent(string2, dimension);
        }

        public double getSpacing() {
            return this.spacing;
        }

        public double[][] getBxArray() {
            return this.bxArray;
        }

        public double[][] getByArray() {
            return this.byArray;
        }

        public boolean contains(double d, double d2) {
            double d3 = Math.abs(d);
            double d4 = Math.abs(d2);
            return d3 >= 0.0 && d3 <= this.getMaxX() && d4 >= 0.0 && d4 <= this.getMaxY();
        }

        private double getMaxX() {
            return this.spacing * (double)(this.size.width - 1);
        }

        private double getMaxY() {
            return this.spacing * (double)(this.size.height - 1);
        }

        private double[][] readComponent(String string, Dimension dimension) {
            int n;
            double[][] dArray = new double[dimension.width][dimension.height];
            int n2 = 0;
            String string2 = null;
            try {
                InputStream inputStream = FaradayResources.getResourceLoader().getResourceAsStream(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string3 = bufferedReader.readLine();
                int n3 = 0;
                int n4 = 0;
                while (string3 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        dArray[n4][n3] = Double.parseDouble(string4);
                        ++n2;
                        if (++n3 != dimension.height) continue;
                        n3 = 0;
                        ++n4;
                    }
                    string3 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                string2 = "could not read " + string;
                iOException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "could not parse number in " + string;
                numberFormatException.printStackTrace();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "more values than expected in " + string;
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            if (string2 == null && n2 < (n = dimension.width * dimension.height)) {
                string2 = "fewer values than expected in " + string;
            }
            if (string2 != null) {
                String string5 = MessageFormat.format(FaradayStrings.ERROR_BAR_MAGNET_INITIALIZATION, string2);
                PhetOptionPane.showErrorDialog(PhetApplication.getInstance().getPhetFrame(), string5);
                System.exit(1);
            }
            return dArray;
        }
    }
}

