/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.panel;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.view.BFieldInsideGraphic;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.ElectromagnetGraphic;
import edu.colorado.phet.faraday.view.LightbulbGraphic;
import edu.colorado.phet.faraday.view.PickupCoilGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeveloperControlsPanel
extends FaradayPanel {
    public DeveloperControlsPanel(final PickupCoil pickupCoil, final PickupCoilGraphic pickupCoilGraphic, final ElectromagnetGraphic electromagnetGraphic, final LightbulbGraphic lightbulbGraphic, final BFieldInsideGraphic bFieldInsideGraphic, final BFieldOutsideGraphic bFieldOutsideGraphic) {
        double d;
        JCheckBox jCheckBox;
        Border border = BorderFactory.createLineBorder(Color.RED, 2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Developer controls");
        titledBorder.setTitleFont(this.getTitleFont());
        this.setBorder(titledBorder);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel("<html>These controls will NOT be reset<br>when you press the Reset All button.");
        jLabel.setForeground(Color.RED);
        easyGridBagLayout.addComponent(jLabel, n++, 0);
        if (electromagnetGraphic != null) {
            jCheckBox = new JCheckBox("Show magnet model shape");
            jCheckBox.setSelected(electromagnetGraphic.isModelShapeVisible());
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = jCheckBox.isSelected();
                    electromagnetGraphic.setModelShapeVisible(bl);
                }
            });
            easyGridBagLayout.addComponent(jCheckBox, n++, 0);
        }
        if (pickupCoilGraphic != null) {
            jCheckBox = new JCheckBox("Show pickup sample points");
            jCheckBox.setSelected(pickupCoilGraphic.isSamplePointsVisible());
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    pickupCoilGraphic.setSamplePointsVisible(jCheckBox.isSelected());
                }
            });
            easyGridBagLayout.addComponent(jCheckBox, n++, 0);
        }
        if (pickupCoilGraphic != null) {
            jCheckBox = new JCheckBox("Display pickup flux");
            jCheckBox.setSelected(pickupCoilGraphic.isFluxDisplayVisible());
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    pickupCoilGraphic.setFluxDisplayVisible(jCheckBox.isSelected());
                }
            });
            easyGridBagLayout.addComponent(jCheckBox, n++, 0);
        }
        if (bFieldInsideGraphic != null || bFieldOutsideGraphic != null) {
            double d2 = 1.0;
            d = 6.0;
            double d3 = bFieldInsideGraphic != null ? bFieldInsideGraphic.getIntensityScale() : bFieldOutsideGraphic.getIntensityScale();
            final LinearValueControl linearValueControl = new LinearValueControl(d2, d, "B-field scale:", "0.0", "");
            linearValueControl.setToolTipText("<html>Scales the brightness of the<br>B-field visualization.</html>");
            linearValueControl.setValue(d3);
            linearValueControl.setTextFieldEditable(true);
            linearValueControl.setTextFieldColumns(3);
            linearValueControl.setUpDownArrowDelta(0.1);
            linearValueControl.setBorder(BorderFactory.createEtchedBorder());
            linearValueControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = linearValueControl.getValue();
                    if (bFieldInsideGraphic != null) {
                        bFieldInsideGraphic.setIntensityScale(d);
                    }
                    if (bFieldOutsideGraphic != null) {
                        bFieldOutsideGraphic.setIntensityScale(d);
                    }
                }
            });
            easyGridBagLayout.addFilledComponent(linearValueControl, n++, 0, 2);
        }
        if (pickupCoil != null) {
            double d4 = 10000.0;
            d = 5000000.0;
            final LinearValueControl linearValueControl = new LinearValueControl(d4, d, "<html>Pickup coil<br>max EMF:</html>", "0", "");
            linearValueControl.setToolTipText("<html>Max EMF that we expect<br>the pickup coil to generate.</html>");
            linearValueControl.setValue(pickupCoil.getCalibrationEmf());
            linearValueControl.setTextFieldEditable(true);
            linearValueControl.setTextFieldColumns(6);
            linearValueControl.setUpDownArrowDelta(1.0);
            linearValueControl.setBorder(BorderFactory.createEtchedBorder());
            linearValueControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = linearValueControl.getValue();
                    pickupCoil.setCalibrationEmf(d);
                }
            });
            easyGridBagLayout.addFilledComponent(linearValueControl, n++, 0, 2);
        }
        if (pickupCoilGraphic != null) {
            double d5 = 1.0;
            d = 100.0;
            final LinearValueControl linearValueControl = new LinearValueControl(d5, d, "<html>Pickup electrons<br>motion scale:</html>", "0.0", "");
            linearValueControl.setToolTipText("<html>Scales the speed of electron<br>motion in the pickup coil.</html>");
            linearValueControl.setValue(pickupCoilGraphic.getCoilGraphic().getElectronSpeedScale());
            linearValueControl.setTextFieldEditable(true);
            linearValueControl.setTextFieldColumns(4);
            linearValueControl.setUpDownArrowDelta(0.1);
            linearValueControl.setBorder(BorderFactory.createEtchedBorder());
            linearValueControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = linearValueControl.getValue();
                    pickupCoilGraphic.getCoilGraphic().setElectronSpeedScale(d);
                }
            });
            easyGridBagLayout.addFilledComponent(linearValueControl, n++, 0, 2);
        }
        if (pickupCoil != null) {
            double d6 = 0.1;
            d = 1.0;
            final LinearValueControl linearValueControl = new LinearValueControl(d6, d, "<html>Pickup transition<br>smoothing scale:</html>", "0.00", "");
            linearValueControl.setToolTipText("<html>Scaling factor used to smooth out<br>abrupt EMF changes when the magnet<br>transitions between inside & outside<br>the pickup coil.</html>");
            linearValueControl.setValue(pickupCoil.getTransitionSmoothingScale());
            linearValueControl.setTextFieldEditable(true);
            linearValueControl.setTextFieldColumns(3);
            linearValueControl.setUpDownArrowDelta(0.01);
            linearValueControl.setBorder(BorderFactory.createEtchedBorder());
            linearValueControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = linearValueControl.getValue();
                    pickupCoil.setTransitionSmoothingScale(d);
                }
            });
            easyGridBagLayout.addFilledComponent(linearValueControl, n++, 0, 2);
        }
        if (lightbulbGraphic != null) {
            double d7 = 1.0;
            d = 100.0;
            final LinearValueControl linearValueControl = new LinearValueControl(d7, d, "Lightbulb glow scale:", "0.0", "");
            linearValueControl.setToolTipText("<html>Adjusts how brightly the lightbulb glows.</html>");
            linearValueControl.setValue(lightbulbGraphic.getGlassGlowScale());
            linearValueControl.setTextFieldEditable(true);
            linearValueControl.setTextFieldColumns(4);
            linearValueControl.setUpDownArrowDelta(0.1);
            linearValueControl.setBorder(BorderFactory.createEtchedBorder());
            linearValueControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = linearValueControl.getValue();
                    lightbulbGraphic.setGlassGlowScale(d);
                }
            });
            easyGridBagLayout.addFilledComponent(linearValueControl, n++, 0, 2);
        }
    }
}

