/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class GraphicSlider
extends GraphicLayerSet {
    private PhetGraphic _knob = null;
    private PhetGraphic _knobHighlight = null;
    private PhetGraphic _track = null;
    private PhetGraphic _background = null;
    private Rectangle _dragBounds = new Rectangle();
    private int _minimum = 0;
    private int _maximum = 100;
    private int _value = (this._maximum - this._minimum) / 2;
    private Dimension _tickSize = new Dimension(1, 12);
    private EventListenerList _listenerList = new EventListenerList();
    private KnobListener _knobListener = new KnobListener();

    public GraphicSlider(Component component) {
        super(component);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHints(renderingHints);
    }

    public void setKnob(PhetGraphic phetGraphic) {
        if (this._knob != null) {
            this.removeGraphic(this._knob);
            this._knob.removeCursor();
            this._knob.removeAllMouseInputListeners();
        }
        this._knob = phetGraphic;
        if (this._knob != null) {
            this.addGraphic(phetGraphic, 3.0);
            this._knob.setCursorHand();
            this._knob.addMouseInputListener(this._knobListener);
        }
        this.update();
    }

    public void setKnobHighlight(PhetGraphic phetGraphic) {
        if (this._knobHighlight != null) {
            this.removeGraphic(this._knobHighlight);
        }
        this._knobHighlight = phetGraphic;
        if (this._knobHighlight != null) {
            this.addGraphic(phetGraphic, 4.0);
            this._knobHighlight.setVisible(false);
            this._knobHighlight.setCursorHand();
            this._knobHighlight.addMouseInputListener(this._knobListener);
        }
        this.update();
    }

    public void setTrack(PhetGraphic phetGraphic) {
        if (this._track != null) {
            this.removeGraphic(phetGraphic);
        }
        this._track = phetGraphic;
        this._dragBounds.setBounds(0, 0, 0, 0);
        if (this._track != null) {
            this.addGraphic(phetGraphic, 2.0);
            phetGraphic.setRegistrationPoint(0, 0);
            if (this._background == null) {
                phetGraphic.setLocation(0, 0);
            } else {
                int n = (this._background.getWidth() - phetGraphic.getWidth()) / 2;
                int n2 = (this._background.getHeight() - phetGraphic.getHeight()) / 2;
                phetGraphic.setLocation(n, n2);
            }
            this._dragBounds.setBounds(phetGraphic.getX(), phetGraphic.getY() + phetGraphic.getHeight() / 2, phetGraphic.getWidth(), 1);
        }
        this.setKnob(this._knob);
    }

    public void setValue(int n) {
        if (n != this._value) {
            this._value = (int)MathUtil.clamp(this._minimum, n, this._maximum);
            this.fireChangeEvent(new ChangeEvent(this));
            this.update();
        }
    }

    public int getValue() {
        return this._value;
    }

    public void setMinimum(int n) {
        this._minimum = n;
        this.update();
    }

    public int getMinimum() {
        return this._minimum;
    }

    public void setMaximum(int n) {
        this._maximum = n;
        this.update();
    }

    public int getMaximum() {
        return this._maximum;
    }

    public void addTick(int n) {
        if (this._track != null && n >= this._minimum && n <= this._maximum) {
            Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, this._tickSize.height);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent());
            phetShapeGraphic.setShape(double_);
            phetShapeGraphic.setBorderColor(Color.BLACK);
            phetShapeGraphic.setStroke(new BasicStroke(this._tickSize.width));
            double d = (double)(n - this._minimum) / (double)(this._maximum - this._minimum);
            int n2 = this._dragBounds.x + (int)(d * (double)this._dragBounds.width);
            int n3 = this._dragBounds.y;
            phetShapeGraphic.setLocation(n2, n3);
            this.addGraphic(phetShapeGraphic, 1.0);
        }
    }

    private void update() {
        double d = (double)(this._value - this._minimum) / (double)(this._maximum - this._minimum);
        int n = this._dragBounds.x + (int)(d * (double)this._dragBounds.width);
        int n2 = this._dragBounds.y;
        if (this._knob != null) {
            this._knob.setLocation(n, n2);
        }
        if (this._knobHighlight != null) {
            this._knobHighlight.setLocation(n, n2);
        }
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class KnobListener
    extends MouseInputAdapter {
        private Point2D _somePoint = new Point2D.Double();

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = 0;
            try {
                AffineTransform affineTransform = GraphicSlider.this.getNetTransform();
                affineTransform.inverseTransform(mouseEvent.getPoint(), this._somePoint);
                n = (int)this._somePoint.getX();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            int n2 = Math.max(((GraphicSlider)GraphicSlider.this)._dragBounds.x, Math.min(((GraphicSlider)GraphicSlider.this)._dragBounds.x + ((GraphicSlider)GraphicSlider.this)._dragBounds.width, n));
            double d = (double)(n2 - ((GraphicSlider)GraphicSlider.this)._dragBounds.x) / (double)((GraphicSlider)GraphicSlider.this)._dragBounds.width;
            int n3 = (int)(d * (double)(GraphicSlider.this._maximum - GraphicSlider.this._minimum)) + GraphicSlider.this._minimum;
            GraphicSlider.this.setValue(n3);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (GraphicSlider.this._knob != null && GraphicSlider.this._knobHighlight != null && GraphicSlider.this._knob.getBounds().contains(mouseEvent.getPoint())) {
                GraphicSlider.this._knobHighlight.setVisible(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (GraphicSlider.this._knob != null && GraphicSlider.this._knobHighlight != null && !GraphicSlider.this._knobHighlight.getBounds().contains(mouseEvent.getPoint())) {
                GraphicSlider.this._knobHighlight.setVisible(false);
            }
        }
    }
}

