/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Font;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLUtils {
    private static final Font DEFAULT_FONT = new PhetFont();

    private HTMLUtils() {
    }

    public static String getHref(String string, String string2) {
        return "<a href=" + string + ">" + string2 + "</a>";
    }

    public static String getPhetHomeHref() {
        return HTMLUtils.getPhetHomeHref("http://phet.colorado.edu");
    }

    public static String getPhetHomeHref(String string) {
        return HTMLUtils.getHref("http://phet.colorado.edu", string);
    }

    public static String getPhetMailtoHref() {
        return HTMLUtils.getPhetMailtoHref("phethelp@colorado.edu");
    }

    public static String getPhetMailtoHref(String string) {
        return HTMLUtils.getHref("mailto:phethelp@colorado.edu", string);
    }

    public static String getSimWebsiteURL(String string, String string2) {
        return "http://phet.colorado.edu/services/sim-website-redirect?request_version=1&project=" + string + "&" + "sim=" + string2;
    }

    public static String getSimJarURL(String string, String string2, Locale locale) {
        String string3 = "http://phet.colorado.edu/services/sim-jar-redirect?request_version=1&project=" + string + "&" + "sim=" + string2 + "&" + "language=" + locale.getLanguage();
        if (!locale.getCountry().equals("")) {
            string3 = string3 + "&country=" + locale.getCountry();
        }
        return string3;
    }

    public static String getProjectJarURL(String string, String string2) {
        return "http://phet.colorado.edu/services/sim-jar-redirect?request_version=1" + string2 + "project=" + string;
    }

    public static String createStyledHTMLFromFragment(String string) {
        return HTMLUtils.createStyledHTMLFromFragment(string, DEFAULT_FONT, "<head><style type=\"text/css\">body { font-size: @FONT_SIZE@; font-family: @FONT_FAMILY@ }</style></head>");
    }

    public static String createStyledHTMLFromFragment(String string, Font font, String string2) {
        String string3 = "<html>" + string2 + string + "</html>";
        return HTMLUtils.setFontInStyledHTML(string3, font);
    }

    public static String setFontInStyledHTML(String string, Font font) {
        string = string.replaceAll("@FONT_SIZE@", font.getSize() + "pt");
        string = string.replaceAll("@FONT_FAMILY@", font.getFamily());
        return string;
    }

    public static String toHTMLString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            string = string.replaceAll("<html>", "");
            string = string.replaceAll("</html>", "");
            stringBuffer.append(string);
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public static String toHTMLString(String string) {
        String[] stringArray = new String[]{string};
        return HTMLUtils.toHTMLString(stringArray);
    }

    public static class InteractiveHTMLPane
    extends HTMLEditorPane {
        public InteractiveHTMLPane(String string) {
            super(string);
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        PhetServiceManager.showWebPage(hyperlinkEvent.getURL());
                    }
                }
            });
        }
    }

    public static class HTMLEditorPane
    extends JEditorPane {
        public HTMLEditorPane(String string) {
            this.setEditorKit(new HTMLEditorKit());
            this.setText(string);
            this.setEditable(false);
        }
    }
}

