/*
 * Decompiled with CFR 0.152.
 */
package com.idautomation.linear;

import com.idautomation.linear.BarCode;
import com.idautomation.linear.encoder.GifEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IDAutomationServlet
extends HttpServlet {
    private boolean debug = true;

    public void init() throws ServletException {
    }

    private BarCode getChart(HttpServletRequest httpServletRequest) {
        BarCode barCode = new BarCode();
        if (httpServletRequest != null) {
            String string = null;
            if (httpServletRequest.getParameter("CODE_TYPE") != null) {
                string = httpServletRequest.getParameter("CODE_TYPE");
                if (string.compareTo("CODE39") == 0) {
                    barCode.barType = 0;
                }
                if (string.compareTo("CODE39EXT") == 0) {
                    barCode.barType = 1;
                }
                if (string.compareTo("INTERLEAVED25") == 0) {
                    barCode.barType = 2;
                }
                if (string.compareTo("CODE11") == 0) {
                    barCode.barType = 3;
                }
                if (string.compareTo("CODABAR") == 0) {
                    barCode.barType = 4;
                }
                if (string.compareTo("MSI") == 0) {
                    barCode.barType = 5;
                }
                if (string.compareTo("UPCA") == 0) {
                    barCode.barType = 6;
                }
                if (string.compareTo("IND25") == 0) {
                    barCode.barType = 7;
                }
                if (string.compareTo("MAT25") == 0) {
                    barCode.barType = 8;
                }
                if (string.compareTo("CODE93") == 0) {
                    barCode.barType = 9;
                }
                if (string.compareTo("EAN13") == 0) {
                    barCode.barType = 10;
                }
                if (string.compareTo("EAN8") == 0) {
                    barCode.barType = 11;
                }
                if (string.compareTo("UPCE") == 0) {
                    barCode.barType = 12;
                }
                if (string.compareTo("CODE128") == 0) {
                    barCode.barType = 13;
                }
                if (string.compareTo("CODE93EXT") == 0) {
                    barCode.barType = 14;
                }
                if (string.compareTo("POSTNET") == 0) {
                    barCode.barType = 15;
                }
                if (string.compareTo("PLANET") == 0) {
                    barCode.barType = 16;
                }
                if (string.compareTo("UCC128") == 0) {
                    barCode.barType = 17;
                }
                if (string.compareTo("ONECODE") == 0) {
                    barCode.barType = 18;
                }
            }
            if (httpServletRequest.getParameter("ROTATE") != null) {
                barCode.rotate = new Integer(httpServletRequest.getParameter("ROTATE"));
            }
            if (httpServletRequest.getParameter("BAR_HEIGHT") != null) {
                barCode.barHeightCM = new Double(httpServletRequest.getParameter("BAR_HEIGHT"));
            }
            if (httpServletRequest.getParameter("X") != null) {
                barCode.X = new Double(httpServletRequest.getParameter("X"));
            }
            if (httpServletRequest.getParameter("N") != null) {
                barCode.N = new Double(httpServletRequest.getParameter("N"));
            }
            if (httpServletRequest.getParameter("LEFT_MARGIN") != null) {
                barCode.leftMarginCM = new Double(httpServletRequest.getParameter("LEFT_MARGIN"));
            }
            if (httpServletRequest.getParameter("TOP_MARGIN") != null) {
                barCode.topMarginCM = new Double(httpServletRequest.getParameter("TOP_MARGIN"));
            }
            if (httpServletRequest.getParameter("CHECK_CHAR") != null) {
                boolean bl = barCode.checkCharacter = httpServletRequest.getParameter("CHECK_CHAR").compareTo("Y") == 0;
            }
            if (httpServletRequest.getParameter("CHECK_CHARINTEXT") != null) {
                boolean bl = barCode.checkCharacterInText = httpServletRequest.getParameter("CHECK_CHARINTEXT").compareTo("Y") == 0;
            }
            if (httpServletRequest.getParameter("ST") != null) {
                boolean bl = barCode.showText = httpServletRequest.getParameter("ST").compareTo("Y") == 0;
            }
            if (httpServletRequest.getParameter("CODE128_SET") != null) {
                barCode.Code128Set = httpServletRequest.getParameter("CODE128_SET").charAt(0);
            }
            barCode.UPCESytem = httpServletRequest.getParameter("UPCE_SYSTEM") != null ? httpServletRequest.getParameter("UPCE_SYSTEM").charAt(0) : (char)50;
            if (httpServletRequest.getParameter("TEXT_FONT") != null) {
                barCode.textFont = this.convertFont(httpServletRequest.getParameter("TEXT_FONT"));
            }
            if (httpServletRequest.getParameter("FONT_COLOR") != null) {
                barCode.fontColor = this.convertColor(httpServletRequest.getParameter("FONT_COLOR"));
            }
            if (httpServletRequest.getParameter("BAR_COLOR") != null) {
                barCode.barColor = this.convertColor(httpServletRequest.getParameter("BAR_COLOR"));
            }
            if (httpServletRequest.getParameter("BACK_COLOR") != null) {
                barCode.backColor = this.convertColor(httpServletRequest.getParameter("BACK_COLOR"));
            }
            if (httpServletRequest.getParameter("PT") != null) {
                boolean bl = barCode.processTilde = httpServletRequest.getParameter("PT").compareTo("Y") == 0;
            }
            if (httpServletRequest.getParameter("CHARACTER_GROUPING") != null) {
                barCode.ValSpliceText = new Integer(httpServletRequest.getParameter("CHARACTER_GROUPING"));
            }
            barCode.code = httpServletRequest.getParameter("BARCODE") != null ? httpServletRequest.getParameter("BARCODE") : "01234567094987654321";
            if (httpServletRequest.getParameter("WHITE_BAR_INCREASE") != null) {
                barCode.WhiteBarIncrease = new Float(httpServletRequest.getParameter("WHITE_BAR_INCREASE")).floatValue();
            }
            if (httpServletRequest.getParameter("BEARER_BAR_HORIZONTAL") != null) {
                barCode.fBearerBarHori = new Float(httpServletRequest.getParameter("BEARER_BAR_HORIZONTAL")).floatValue();
            }
            if (httpServletRequest.getParameter("BEARER_BAR_VERTICAL") != null) {
                barCode.fBearerBarVert = new Float(httpServletRequest.getParameter("BEARER_BAR_VERTICAL")).floatValue();
            }
            if (httpServletRequest.getParameter("TEXT_MARGIN") != null) {
                barCode.textMarginCM = new Float(httpServletRequest.getParameter("TEXT_MARGIN")).floatValue();
            }
        } else {
            barCode.code = "No Data";
        }
        return barCode;
    }

    public Font convertFont(String string) {
        String[] stringArray = this.convertList(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length < 3) {
            return null;
        }
        int n = 0;
        if (stringArray[1].compareTo("BOLD") == 0) {
            n = 1;
        }
        if (stringArray[1].compareTo("ITALIC") == 0) {
            n = 2;
        }
        try {
            return new Font(stringArray[0], n, new Integer(stringArray[2]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String[] convertList(String string) {
        String[] stringArray = new String[500];
        int n = 0;
        int n2 = string.indexOf("|");
        while (n2 >= 0) {
            stringArray[n++] = string.substring(0, n2);
            string = string.substring(n2 + 1, string.length());
            n2 = string.indexOf("|");
        }
        if (string.compareTo("") != 0) {
            stringArray[n++] = string;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray2[n3] = stringArray[n3];
            ++n3;
        }
        return stringArray2;
    }

    public Color convertColor(String string) {
        if (string.compareTo("NULL") == 0) {
            return null;
        }
        if (string.compareTo("RED") == 0) {
            return Color.red;
        }
        if (string.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (string.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (string.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (string.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (string.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (string.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (string.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (string.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (string.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (string.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (string.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (string.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            return Color.black;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "jpeg";
        if (httpServletRequest != null) {
            if (httpServletRequest.getParameter("FORMAT") != null) {
                string = httpServletRequest.getParameter("FORMAT").toLowerCase();
            }
            if (string.compareTo("gif") != 0) {
                string = "jpeg";
            }
        }
        httpServletResponse.setContentType("image/" + string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        try {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            int n = 10;
            int n2 = 10;
            BarCode barCode = this.getChart(httpServletRequest);
            if (httpServletRequest != null && httpServletRequest.getParameter("WIDTH") != null && httpServletRequest.getParameter("HEIGHT") != null) {
                n = new Integer(httpServletRequest.getParameter("WIDTH"));
                n2 = new Integer(httpServletRequest.getParameter("HEIGHT"));
            } else {
                barCode.autoSize = true;
                barCode.setSize(600, 90);
                bufferedImage = new BufferedImage(barCode.getSize().width, barCode.getSize().height, 13);
                graphics2D = bufferedImage.createGraphics();
                barCode.paint(graphics2D);
                barCode.invalidate();
                n = barCode.getSize().width;
                n2 = barCode.getSize().height;
                graphics2D.dispose();
            }
            bufferedImage = new BufferedImage(n, n2, 1);
            graphics2D = bufferedImage.createGraphics();
            if (this.debug) {
                System.out.println("Size: " + n + " " + n2);
            }
            barCode.setSize(n, n2);
            barCode.paint(graphics2D);
            if (string.compareToIgnoreCase("gif") == 0) {
                GifEncoder gifEncoder = new GifEncoder(bufferedImage, (OutputStream)servletOutputStream);
                gifEncoder.encode();
            } else {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)servletOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality(1.0f, true);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.doGet(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

