/*
 * Decompiled with CFR 0.152.
 */
package com.idautomation.linear;

import com.idautomation.linear.BarCode;
import com.idautomation.linear.encoder.GifEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IDAutomationSecureServlet
extends HttpServlet {
    private boolean debug = false;

    public void init() throws ServletException {
    }

    private BarCode getChart(HttpServletRequest httpServletRequest) {
        BarCode barCode = new BarCode();
        barCode.code = "SecureServlet";
        return barCode;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "jpeg";
        if (httpServletRequest != null) {
            if (httpServletRequest.getParameter("FORMAT") != null) {
                string = httpServletRequest.getParameter("FORMAT").toLowerCase();
            }
            if (string.compareTo("gif") != 0) {
                string = "jpeg";
            }
        }
        httpServletResponse.setContentType("image/" + string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        try {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            int n = 10;
            int n2 = 10;
            BarCode barCode = this.getChart(httpServletRequest);
            if (httpServletRequest != null && httpServletRequest.getParameter("WIDTH") != null && httpServletRequest.getParameter("HEIGHT") != null) {
                n = new Integer(httpServletRequest.getParameter("WIDTH"));
                n2 = new Integer(httpServletRequest.getParameter("HEIGHT"));
            } else {
                barCode.autoSize = true;
                barCode.setSize(170, 90);
                bufferedImage = new BufferedImage(barCode.getSize().width, barCode.getSize().height, 13);
                graphics2D = bufferedImage.createGraphics();
                barCode.paint(graphics2D);
                barCode.invalidate();
                n = barCode.getSize().width;
                n2 = barCode.getSize().height;
                graphics2D.dispose();
            }
            bufferedImage = new BufferedImage(n, n2, 1);
            graphics2D = bufferedImage.createGraphics();
            if (this.debug) {
                System.out.println("Size: " + n + " " + n2);
            }
            barCode.setSize(n, n2);
            barCode.paint(graphics2D);
            if (string.compareToIgnoreCase("gif") == 0) {
                barCode.setSize(n, n2);
                GifEncoder gifEncoder = new GifEncoder(bufferedImage, (OutputStream)servletOutputStream);
                gifEncoder.encode();
            } else {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)servletOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality(1.0f, true);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.doGet(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

