/*
 * Decompiled with CFR 0.152.
 */
package com.idautomation.linear;

import com.idautomation.linear.IDAImageCreator;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;

public class BarCode
extends Canvas
implements Serializable {
    public static final int CODE39 = 0;
    public static final int CODE39EXT = 1;
    public static final int INTERLEAVED25 = 2;
    public static final int CODE11 = 3;
    public static final int CODABAR = 4;
    public static final int MSI = 5;
    public static final int UPCA = 6;
    public static final int IND25 = 7;
    public static final int MAT25 = 8;
    public static final int CODE93 = 9;
    public static final int EAN13 = 10;
    public static final int EAN8 = 11;
    public static final int UPCE = 12;
    public static final int CODE128 = 13;
    public static final int CODE93EXT = 14;
    public static final int POSTNET = 15;
    public static final int PLANET = 16;
    public static final int UCC128 = 17;
    public static final int ONECODE = 18;
    public int barType = 13;
    static int TABLE_2_OF_13_SIZE = 78;
    static int TABLE_5_OF_13_SIZE = 1287;
    static boolean Table2of13InitializedFlag = false;
    static boolean Table5of13InitializedFlag = false;
    static long NumberOf5of13TableEntries = 0L;
    static long NumberOf2of13TableEntries = 0L;
    static short Remainder = 0;
    static int[] Table2of13 = new int[TABLE_2_OF_13_SIZE];
    static int[] Table5of13 = new int[TABLE_5_OF_13_SIZE];
    static int[] BarTopCharacterIndexArray = new int[]{4, 0, 2, 6, 3, 5, 1, 9, 8, 7, 1, 2, 0, 6, 4, 8, 2, 9, 5, 3, 0, 1, 3, 7, 4, 6, 8, 9, 2, 0, 5, 1, 9, 4, 3, 8, 6, 7, 1, 2, 4, 3, 9, 5, 7, 8, 3, 0, 2, 1, 4, 0, 9, 1, 7, 0, 2, 4, 6, 3, 7, 1, 9, 5, 8};
    static int[] BarBottomCharacterIndexArray = new int[]{7, 1, 9, 5, 8, 0, 2, 4, 6, 3, 5, 8, 9, 7, 3, 0, 6, 1, 7, 4, 6, 8, 9, 2, 5, 1, 7, 5, 4, 3, 8, 7, 6, 0, 2, 5, 4, 9, 3, 0, 1, 6, 8, 2, 0, 4, 5, 9, 6, 7, 5, 2, 6, 3, 8, 5, 1, 9, 8, 7, 4, 0, 2, 6, 3};
    static int[] BarTopCharacterShiftArray = new int[]{3, 0, 8, 11, 1, 12, 8, 11, 10, 6, 4, 12, 2, 7, 9, 6, 7, 9, 2, 8, 4, 0, 12, 7, 10, 9, 0, 7, 10, 5, 7, 9, 6, 8, 2, 12, 1, 4, 2, 0, 1, 5, 4, 6, 12, 1, 0, 9, 4, 7, 5, 10, 2, 6, 9, 11, 2, 12, 6, 7, 5, 11, 0, 3, 2};
    static int[] BarBottomCharacterShiftArray = new int[]{2, 10, 12, 5, 9, 1, 5, 4, 3, 9, 11, 5, 10, 1, 6, 3, 4, 1, 10, 0, 2, 11, 8, 6, 1, 12, 3, 8, 6, 4, 4, 11, 0, 6, 1, 9, 11, 5, 3, 7, 3, 10, 7, 11, 8, 2, 10, 3, 5, 8, 0, 3, 12, 11, 8, 4, 5, 1, 3, 0, 7, 12, 9, 8, 10};
    static int[] Table5of13ArrayPtr = new int[TABLE_5_OF_13_SIZE];
    static int[] Table2of13ArrayPtr = new int[TABLE_2_OF_13_SIZE];
    static double[][] CodewordArray = new double[10][2];
    int[] byteArray = new int[13];
    public String code;
    private String propCode = this.code = "123456789012";
    private String codeSup = "";
    private int demoPixelW = 0;
    private int codeTextW = 0;
    public double textMarginCM = 0.3;
    private int textMarginPixels = 0;
    private int XdimPixels = 0;
    private int WhiteBarIncreasePixels = 0;
    float fXdimPixels = 0.0f;
    public boolean checkCharacter = true;
    public boolean checkCharacterInText = true;
    public boolean processTilde = true;
    public double postnetHeightTallBar = 0.3;
    public double postnetHeightShortBar = 0.125;
    public double leftMarginCM = 0.3;
    protected static final int d = 3;
    public double topMarginCM = 0.2;
    protected int leftMarginPixels = 0;
    protected int topMarginPixels = 0;
    private int leftGuardBar = 0;
    private int centerGuardBarStart = 0;
    private int centerGuardBarEnd = 0;
    private int rightGuardBar = 0;
    private int endOfCode = 0;
    private int startSuplement;
    private int endSuplement;
    private int suplementTopMargin;
    public String supplement = "";
    public boolean guardBars = true;
    public Color backColor = Color.white;
    public String codeText = "";
    protected int narrowBarPixels = 0;
    protected int widthBarPixels = 0;
    protected double narrowBarCM = 0.0;
    protected double widthBarCM = 0.0;
    public int resolution = 38;
    protected int barHeightPixels = 0;
    public double barHeightCM = 1.0;
    public int width = 170;
    public int height = 90;
    public int pWidth = this.width;
    public int pHeight = this.height;
    public boolean autoSize = true;
    public boolean showText = true;
    public Font textFont = new Font("Arial", 0, 11 * (int)((double)this.resolution * 0.027));
    public Color fontColor = Color.black;
    public Color barColor = Color.black;
    private int extraHeight = 0;
    public char UPCESytem = (char)48;
    public char CODABARStartChar = (char)65;
    public char CODABARStopChar = (char)66;
    public boolean UPCEANSupplement2 = false;
    public boolean UPCEANSupplement5 = false;
    public char Code128Set = (char)48;
    public double X = 0.03;
    public double N = 2.0;
    public double I = 1.0;
    public double H = 0.45;
    public double L = 0.0;
    public int rotate = 0;
    public double supSeparationCM = 0.5;
    public double supHeight = 0.8;
    protected int currentX = 0;
    protected int currentY = 0;
    protected int currentXStart = 0;
    protected String[][] set39 = new String[][]{{"0", "nnnwwnwnn"}, {"1", "wnnwnnnnw"}, {"2", "nnwwnnnnw"}, {"3", "wnwwnnnnn"}, {"4", "nnnwwnnnw"}, {"5", "wnnwwnnnn"}, {"6", "nnwwwnnnn"}, {"7", "nnnwnnwnw"}, {"8", "wnnwnnwnn"}, {"9", "nnwwnnwnn"}, {"A", "wnnnnwnnw"}, {"B", "nnwnnwnnw"}, {"C", "wnwnnwnnn"}, {"D", "nnnnwwnnw"}, {"E", "wnnnwwnnn"}, {"F", "nnwnwwnnn"}, {"G", "nnnnnwwnw"}, {"H", "wnnnnwwnn"}, {"I", "nnwnnwwnn"}, {"J", "nnnnwwwnn"}, {"K", "wnnnnnnww"}, {"L", "nnwnnnnww"}, {"M", "wnwnnnnwn"}, {"N", "nnnnwnnww"}, {"O", "wnnnwnnwn"}, {"P", "nnwnwnnwn"}, {"Q", "nnnnnnwww"}, {"R", "wnnnnnwwn"}, {"S", "nnwnnnwwn"}, {"T", "nnnnwnwwn"}, {"U", "wwnnnnnnw"}, {"V", "nwwnnnnnw"}, {"W", "wwwnnnnnn"}, {"X", "nwnnwnnnw"}, {"Y", "wwnnwnnnn"}, {"Z", "nwwnwnnnn"}, {"-", "nwnnnnwnw"}, {".", "wwnnnnwnn"}, {" ", "nwwnnnwnn"}, {"$", "nwnwnwnnn"}, {"/", "nwnwnnnwn"}, {"+", "nwnnnwnwn"}, {"%", "nnnwnwnwn"}, {"*", "nwnnwnwnn"}};
    protected String[][] set25 = new String[][]{{"0", "nnwwn"}, {"1", "wnnnw"}, {"2", "nwnnw"}, {"3", "wwnnn"}, {"4", "nnwnw"}, {"5", "wnwnn"}, {"6", "nwwnn"}, {"7", "nnnww"}, {"8", "wnnwn"}, {"9", "nwnwn"}};
    protected String[][] setMSI = new String[][]{{"0", "nwnwnwnw"}, {"1", "nwnwnwwn"}, {"2", "nwnwwnnw"}, {"3", "nwnwwnwn"}, {"4", "nwwnnwnw"}, {"5", "nwwnnwwn"}, {"6", "nwwnwnnw"}, {"7", "nwwnwnwn"}, {"8", "wnnwnwnw"}, {"9", "wnnwnwwn"}};
    protected String[][] set11 = new String[][]{{"0", "nnnnw"}, {"1", "wnnnw"}, {"2", "nwnnw"}, {"3", "wwnnn"}, {"4", "nnwnw"}, {"5", "wnwnn"}, {"6", "nwwnn"}, {"7", "nnnww"}, {"8", "wnnwn"}, {"9", "wnnnn"}, {"-", "nnwnn"}};
    protected String[][] setCODABAR = new String[][]{{"0", "nnnnnww"}, {"1", "nnnnwwn"}, {"2", "nnnwnnw"}, {"3", "wwnnnnn"}, {"4", "nnwnnwn"}, {"5", "wnnnnwn"}, {"6", "nwnnnnw"}, {"7", "nwnnwnn"}, {"8", "nwwnnnn"}, {"9", "wnnwnnn"}, {"-", "nnnwwnn"}, {"$", "nnwwnnn"}, {":", "wnnnwnw"}, {"/", "wnwnnnw"}, {".", "wnwnwnn"}, {"+", "nnwnwnw"}, {"A", "nnwwnwn"}, {"B", "nwnwnnw"}, {"C", "nnnwnww"}, {"D", "nnnwwwn"}};
    protected String[][] set93 = new String[][]{{"0", "131112"}, {"1", "111213"}, {"2", "111312"}, {"3", "111411"}, {"4", "121113"}, {"5", "121212"}, {"6", "121311"}, {"7", "111114"}, {"8", "131211"}, {"9", "141111"}, {"A", "211113"}, {"B", "211212"}, {"C", "211311"}, {"D", "221112"}, {"E", "221211"}, {"F", "231111"}, {"G", "112113"}, {"H", "112212"}, {"I", "112311"}, {"J", "122112"}, {"K", "132111"}, {"L", "111123"}, {"M", "111222"}, {"N", "111321"}, {"O", "121122"}, {"P", "131121"}, {"Q", "212112"}, {"R", "212211"}, {"S", "211122"}, {"T", "211221"}, {"U", "221121"}, {"V", "222111"}, {"W", "112122"}, {"X", "112221"}, {"Y", "122121"}, {"Z", "123111"}, {"-", "121131"}, {".", "311112"}, {" ", "311211"}, {"$", "321111"}, {"/", "112131"}, {"+", "113121"}, {"%", "211131"}, {"_1", "121221"}, {"_2", "312111"}, {"_3", "311121"}, {"_4", "122211"}};
    protected String[][] setUPCALeft = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCARight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEOdd = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEEven = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[] set39Ext = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    protected String[] set93Ext = new String[]{"_2U", "_1A", "_1B", "_1C", "_1D", "_1E", "_1F", "_1G", "_1H", "_1I", "_1J", "_1K", "_1L", "_1M", "_1N", "_1O", "_1P", "_1Q", "_1R", "_1S", "_1T", "_1U", "_1V", "_1W", "_1X", "_1Y", "_1Z", "_2A", "_2B", "_2C", "_2D", "_2E", " ", "_3A", "_3B", "_3C", "_3D", "_3E", "_3F", "_3G", "_3H", "_3I", "_3J", "_3K", "_3L", "-", ".", "_3O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_3Z", "_2F", "_2G", "_2H", "_2I", "_2J", "_2V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "_2K", "_2L", "_2M", "_2N", "_2O", "_2W", "_4A", "_4B", "_4C", "_4D", "_4E", "_4F", "_4G", "_4H", "_4I", "_4J", "_4K", "_4L", "_4M", "_4N", "_4O", "_4P", "_4Q", "_4R", "_4S", "_4T", "_4U", "_4V", "_4W", "_4X", "_4Y", "_4Z", "_2P", "_2Q", "_2R", "_2S", "_2T"};
    protected String[] UPCESystem0 = new String[]{"EEEOOO", "EEOEOO", "EEOOEO", "EEOOOE", "EOEEOO", "EOOEEO", "EOOOEE", "EOEOEO", "EOEOOE", "EOOEOE"};
    protected String[] UPCESystem1 = new String[]{"OOOEEE", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    protected String[][] setEANLeftA = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setEANLeftB = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[][] setEANRight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[] setEANCode = new String[]{"AAAAA", "ABABB", "ABBAB", "ABBBA", "BAABB", "BBAAB", "BBBAA", "BABAB", "BABBA", "BBABA"};
    protected String[] fiveSuplement = new String[]{"EEOOO", "EOEOO", "EOOEO", "EOOOE", "OEEOO", "OOEEO", "OOOEE", "OEOEO", "OEOOE", "OOEOE"};
    protected String[] set128 = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131"};
    protected String[] set128B = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\u00c3", "\u00c4", "\u00c5", "\u00c6", "\u00c7", "\u00c8", "\u00c9", "\u00ca"};
    protected String[] set128C = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "\u00c8\u00c8", "\u00c9\u00c9", "\u00ca\u00ca"};
    protected String[][] setPOSTNET = new String[][]{{"0", "11000"}, {"1", "00011"}, {"2", "00101"}, {"3", "00110"}, {"4", "01001"}, {"5", "01010"}, {"6", "01100"}, {"7", "10001"}, {"8", "10010"}, {"9", "10100"}};
    protected String[][] setPLANET = new String[][]{{"0", "00111"}, {"1", "11100"}, {"2", "11010"}, {"3", "11001"}, {"4", "10110"}, {"5", "10101"}, {"6", "10011"}, {"7", "01110"}, {"8", "01101"}, {"9", "01011"}};
    private float PropWhiteBarIncrease = 0.0f;
    public float WhiteBarIncrease = 0.0f;
    int ValSpliceText = 0;
    public double fBearerBarVert = 0.0;
    private double PropBearerBarVert = 0.0;
    public double fBearerBarHori = 0.0;
    private double PropBearerBarHori = 0.0;

    public void setSymbologyID(int n) {
        this.barType = n;
        this.invalidate();
    }

    public int getSymbologyID() {
        return this.barType;
    }

    public void setDataToEncode(String string) {
        this.code = string;
        this.invalidate();
    }

    public String getDataToEncode() {
        return this.code;
    }

    public void setTextMarginCM(double d) {
        if (d > 10.0) {
            d = 10.0;
        }
        if (!this.showText) {
            d = 0.3;
        }
        this.textMarginCM = d;
        this.invalidate();
    }

    public double getTextMarginCM() {
        return this.textMarginCM;
    }

    public void setCheckCharacter(boolean bl) {
        this.checkCharacter = bl;
        this.invalidate();
    }

    public boolean getCheckCharacter() {
        return this.checkCharacter;
    }

    public void setCheckCharacterInText(boolean bl) {
        this.checkCharacterInText = bl;
        this.invalidate();
    }

    public boolean getCheckCharacterInText() {
        return this.checkCharacterInText;
    }

    public boolean getProcessTilde() {
        return this.processTilde;
    }

    public void setProcessTilde(boolean bl) {
        this.processTilde = bl;
    }

    public void setPostnetHeightTall(double d) {
        this.postnetHeightTallBar = d;
        this.invalidate();
    }

    public double getPostnetHeightTall() {
        return this.postnetHeightTallBar;
    }

    public void setPostnetHeightShort(double d) {
        this.postnetHeightShortBar = d;
        this.invalidate();
    }

    public double getPostnetHeightShort() {
        return this.postnetHeightShortBar;
    }

    public void setLeftMarginCM(double d) {
        if (this.fBearerBarVert > 0.0 && d < 10.0 * this.X) {
            d = 10.0 * this.X;
        }
        this.leftMarginCM = d;
        this.invalidate();
    }

    public double getLeftMarginCM() {
        return this.leftMarginCM;
    }

    public void setTopMarginCM(double d) {
        this.topMarginCM = d;
        this.invalidate();
    }

    public double getTopMarginCM() {
        return this.topMarginCM;
    }

    public void setSupplementToEncode(String string) {
        if (string.length() == 2) {
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (string.length() == 5) {
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        this.supplement = string.length() == 2 || string.length() == 5 ? string : "";
        this.invalidate();
    }

    public String getSupplementToEncode() {
        return this.supplement;
    }

    public void setBackground(Color color) {
        this.backColor = color;
        this.invalidate();
    }

    public Color getBackground() {
        return this.backColor;
    }

    public void setPixelsPerCM(int n) {
        this.resolution = n;
        this.invalidate();
    }

    public int getPixelsPerCM() {
        return this.resolution;
    }

    public void setBarHeightCM(double d) {
        this.barHeightCM = d;
        this.invalidate();
    }

    public double getBarHeightCM() {
        return this.barHeightCM;
    }

    public void setAutoSize(boolean bl) {
        this.autoSize = bl;
        this.invalidate();
    }

    public boolean getAutoSize() {
        return this.autoSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.pWidth, this.pHeight);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(10, 10);
        return dimension;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
        this.invalidate();
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void setFont(Font font) {
        this.textFont = font;
        this.invalidate();
    }

    public Font getFont() {
        return this.textFont;
    }

    public void setTextFontColor(Color color) {
        this.fontColor = color;
        this.invalidate();
    }

    public Color getTextFontColor() {
        return this.fontColor;
    }

    public void setForeground(Color color) {
        this.barColor = color;
        this.invalidate();
    }

    public Color getForeground() {
        return this.barColor;
    }

    public void setUPCESytem(String string) {
        if (string.equals("0")) {
            this.UPCESytem = (char)48;
        }
        if (string.equals("1")) {
            this.UPCESytem = (char)49;
        }
        if (string.equals("2")) {
            this.UPCESytem = (char)50;
        }
        this.invalidate();
    }

    public String getUPCESytem() {
        String string = "";
        if (this.UPCESytem == '0') {
            string = "0";
        }
        if (this.UPCESytem == '1') {
            string = "1";
        }
        if (this.UPCESytem == '2') {
            string = "2";
        }
        return string;
    }

    public void setCODABARStartChar(String string) {
        if (string.equals("B")) {
            this.CODABARStartChar = (char)66;
        }
        if (string.equals("A")) {
            this.CODABARStartChar = (char)65;
        }
        if (string.equals("C")) {
            this.CODABARStartChar = (char)67;
        }
        if (string.equals("D")) {
            this.CODABARStartChar = (char)68;
        }
        this.invalidate();
    }

    public String getCODABARStartChar() {
        String string = "";
        if (this.CODABARStartChar == 'B') {
            string = "B";
        }
        if (this.CODABARStartChar == 'A') {
            string = "A";
        }
        if (this.CODABARStartChar == 'C') {
            string = "C";
        }
        if (this.CODABARStartChar == 'D') {
            string = "D";
        }
        return string;
    }

    public void setCODABARStopChar(String string) {
        if (string.equals("B")) {
            this.CODABARStopChar = (char)66;
        }
        if (string.equals("A")) {
            this.CODABARStopChar = (char)65;
        }
        if (string.equals("C")) {
            this.CODABARStopChar = (char)67;
        }
        if (string.equals("D")) {
            this.CODABARStopChar = (char)68;
        }
        this.invalidate();
    }

    public String getCODABARStopChar() {
        String string = "";
        if (this.CODABARStopChar == 'B') {
            string = "B";
        }
        if (this.CODABARStopChar == 'A') {
            string = "A";
        }
        if (this.CODABARStopChar == 'C') {
            string = "C";
        }
        if (this.CODABARStopChar == 'D') {
            string = "D";
        }
        return string;
    }

    public void setUPCEANSupplement2(boolean bl) {
        this.UPCEANSupplement2 = bl;
        this.invalidate();
    }

    public boolean getUPCEANSupplement2() {
        return this.UPCEANSupplement2;
    }

    public void setUPCEANSupplement5(boolean bl) {
        this.UPCEANSupplement5 = bl;
        this.invalidate();
    }

    public boolean getUPCEANSupplement5() {
        return this.UPCEANSupplement5;
    }

    public void setCode128Set(String string) {
        if (string.toUpperCase().equals("B")) {
            this.Code128Set = (char)66;
        }
        if (string.toUpperCase().equals("A")) {
            this.Code128Set = (char)65;
        }
        if (string.toUpperCase().equals("C")) {
            this.Code128Set = (char)67;
        }
        if (string.toUpperCase().equals("AUTO")) {
            this.Code128Set = (char)48;
        }
        if (string.toUpperCase().equals("0")) {
            this.Code128Set = (char)48;
        }
        this.invalidate();
    }

    public String getCode128Set() {
        String string = "";
        if (this.Code128Set == 'B') {
            string = "B";
        }
        if (this.Code128Set == 'A') {
            string = "A";
        }
        if (this.Code128Set == 'C') {
            string = "C";
        }
        if (this.Code128Set == '0') {
            string = "0";
        }
        return string;
    }

    public void setXDimensionCM(double d) {
        this.X = d;
        this.invalidate();
    }

    public double getXDimensionCM() {
        return this.X;
    }

    public void setNarrowToWideRatio(double d) {
        this.N = d;
        this.invalidate();
    }

    public double getNarrowToWideRatio() {
        return this.N;
    }

    public void setRotationAngle(int n) {
        this.rotate = n;
        this.invalidate();
    }

    public int getRotationAngle() {
        return this.rotate;
    }

    public void setWhiteBarIncrease(float f) {
        this.PropWhiteBarIncrease = f;
        if (this.PropWhiteBarIncrease < 1.0f && this.PropWhiteBarIncrease != 0.0f) {
            this.PropWhiteBarIncrease = 1.0f;
        }
        if (this.PropWhiteBarIncrease > 99.0f) {
            this.PropWhiteBarIncrease = 99.0f;
        }
        if (f >= 1.0f && f <= 99.0f) {
            f /= 100.0f;
        }
        this.WhiteBarIncrease = f;
        this.invalidate();
    }

    public float getWhiteBarIncrease() {
        return this.PropWhiteBarIncrease;
    }

    public void setCharacterGrouping(int n) {
        this.ValSpliceText = n >= 3 && n <= 5 && this.barType != 18 ? n : 0;
        this.invalidate();
    }

    public int getCharacterGrouping() {
        return this.ValSpliceText;
    }

    public void setBearerBarVertical(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 10.0) {
            d = 10.0;
        }
        this.PropBearerBarVert = d;
        this.fBearerBarVert = d;
        if (this.barType == 15 || this.barType == 16 || this.barType == 18) {
            this.PropBearerBarVert = 0.0;
        }
        this.invalidate();
    }

    public double getBearerBarVertical() {
        return this.PropBearerBarVert;
    }

    public void setBearerBarHorizontal(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 10.0) {
            d = 10.0;
        }
        this.PropBearerBarHori = d;
        this.fBearerBarHori = d;
        if (this.barType == 15 || this.barType == 16 || this.barType == 18) {
            this.PropBearerBarHori = 0.0;
        }
        this.invalidate();
    }

    public double getBearerBarHorizontal() {
        return this.PropBearerBarHori;
    }

    protected void addBar(Graphics graphics, int n, boolean bl, int n2, boolean bl2) {
        if (bl && bl2) {
            graphics.setColor(this.barColor);
            graphics.fillRect(this.currentX, this.topMarginPixels + n2, n, this.barHeightPixels + this.extraHeight - n2);
        }
        this.currentX += n;
        this.fXdimPixels = this.XdimPixels;
        this.currentX += (int)(this.fXdimPixels * this.WhiteBarIncrease);
    }

    protected void paintPostNetChar(Graphics graphics, String string) {
        int n = (int)(this.postnetHeightShortBar * (double)this.resolution);
        int n2 = (int)(this.postnetHeightTallBar * (double)this.resolution);
        graphics.setColor(this.barColor);
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '1') {
                graphics.fillRect(this.currentX, this.topMarginPixels, this.narrowBarPixels, n2 + this.extraHeight);
            }
            if (c == '0') {
                graphics.fillRect(this.currentX, this.topMarginPixels + (n2 - n), this.narrowBarPixels, n + this.extraHeight);
            }
            this.currentX += this.narrowBarPixels;
            this.currentX += this.widthBarPixels;
            this.fXdimPixels = this.XdimPixels;
            this.currentX += (int)(this.fXdimPixels * this.WhiteBarIncrease);
            ++n3;
        }
    }

    protected void paintPOSTNET(Graphics graphics, boolean bl) {
        String string;
        int n = 0;
        int n2 = 0;
        String string2 = this.code;
        String string3 = "";
        this.paintPostNetChar(graphics, "1");
        int n3 = this.code.length() - 1;
        while (n3 >= 0) {
            string = "" + this.code.charAt(n3);
            if (this.findChar(this.setPOSTNET, string) != -1) {
                n2 += this.findChar(this.setPOSTNET, string);
            }
            --n3;
        }
        int n4 = (int)BarCode.mod(n2, 10.0);
        if (n4 != 0) {
            n4 = 10 - n4;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n4).toString();
        }
        int n5 = 0;
        while (n5 < string2.length()) {
            string = "" + string2.charAt(n5);
            n = this.findChar(this.setPOSTNET, string);
            if (n != -1) {
                this.paintPostNetChar(graphics, this.setPOSTNET[n][1]);
                string3 = string3 + new Integer(n).toString();
            }
            ++n5;
        }
        this.paintPostNetChar(graphics, "1");
        this.codeText = this.checkCharacterInText || !this.checkCharacter && !this.checkCharacterInText ? string3 : string3.substring(0, string3.length() - 1);
    }

    protected int findChar(String[][] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n][0]) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void paintPLANET(Graphics graphics, boolean bl) {
        String string;
        int n = 0;
        int n2 = 0;
        String string2 = this.code;
        String string3 = "";
        this.paintPostNetChar(graphics, "1");
        int n3 = this.code.length() - 1;
        while (n3 >= 0) {
            string = "" + this.code.charAt(n3);
            if (this.findChar(this.setPLANET, string) != -1) {
                n2 += this.findChar(this.setPLANET, string);
            }
            --n3;
        }
        int n4 = (int)BarCode.mod(n2, 10.0);
        if (n4 != 0) {
            n4 = 10 - n4;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n4).toString();
        }
        int n5 = 0;
        while (n5 < string2.length()) {
            string = "" + string2.charAt(n5);
            n = this.findChar(this.setPLANET, string);
            if (n != -1) {
                this.paintPostNetChar(graphics, this.setPLANET[n][1]);
                string3 = string3 + new Integer(n).toString();
            }
            ++n5;
        }
        this.paintPostNetChar(graphics, "1");
        this.codeText = this.checkCharacterInText || !this.checkCharacter && !this.checkCharacterInText ? string3 : string3.substring(0, string3.length() - 1);
    }

    protected void paintInterleaved25(Graphics graphics, boolean bl) {
        String string;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        String string2 = this.code;
        int n3 = 0;
        while (n3 < this.code.length()) {
            if (this.code.charAt(n3) < '0' || this.code.charAt(n3) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n3;
        }
        this.paintChar(graphics, "bwbw", "nnnn", bl);
        String string3 = "";
        if (BarCode.mod(this.code.length(), 2.0) == 0.0 && this.checkCharacter) {
            string2 = "0" + this.code;
        }
        if (BarCode.mod(this.code.length(), 2.0) == 1.0 && !this.checkCharacter) {
            string2 = "0" + this.code;
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = true;
        int n6 = string2.length() - 1;
        while (n6 >= 0) {
            string = "" + string2.charAt(n6);
            if (bl3) {
                n4 += this.findChar(this.set25, string);
            } else {
                n5 += this.findChar(this.set25, string);
            }
            bl3 = !bl3;
            --n6;
        }
        int n7 = n4 * 3 + n5;
        if ((n7 = (int)BarCode.mod(n7, 10.0)) != 0) {
            n7 = 10 - n7;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n7).toString();
        }
        int n8 = 0;
        while (n8 < string2.length()) {
            string = "" + string2.charAt(n8);
            String string4 = "" + string2.charAt(n8 + 1);
            n = this.findChar(this.set25, string);
            n2 = this.findChar(this.set25, string4);
            int n9 = 0;
            while (n9 < 5) {
                this.paintChar(graphics, "b", "" + this.set25[n][1].charAt(n9), bl);
                this.paintChar(graphics, "w", "" + this.set25[n2][1].charAt(n9), bl);
                ++n9;
            }
            n8 += 2;
        }
        this.paintChar(graphics, "bwb", "wnn", bl);
        this.codeText = this.checkCharacterInText ? string2 : this.code;
    }

    protected void paintIND25(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        String string = this.code;
        this.paintChar(graphics, "bwbwbw", "wwwwnw", bl);
        int n2 = 0;
        while (n2 < string.length()) {
            String string2 = "" + string.charAt(n2);
            n = this.findChar(this.set25, string2);
            if (n >= 0) {
                int n3 = 0;
                while (n3 < this.set25[n][1].length()) {
                    this.paintChar(graphics, "b", "" + this.set25[n][1].charAt(n3), bl);
                    this.paintChar(graphics, "w", "w", bl);
                    ++n3;
                }
            }
            ++n2;
        }
        this.paintChar(graphics, "bwbwb", "wwnww", bl);
    }

    protected String UPCEANCheck(String string) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            if (bl) {
                n += new Integer("" + string.charAt(n4)).intValue();
            } else {
                n2 += new Integer("" + string.charAt(n4)).intValue();
            }
            bl = !bl;
            --n4;
        }
        n3 = (int)BarCode.mod(n2 = n * 3 + n2, 10.0);
        if (n3 != 0) {
            n3 = 10 - n3;
        }
        return "" + n3;
    }

    protected void paintUPCA(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        String string = "";
        int n2 = 0;
        while (n2 < this.code.length()) {
            if (this.code.charAt(n2) < '0' || this.code.charAt(n2) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n2;
        }
        if (this.code.length() < 11) {
            return;
        }
        if (this.code.length() == 13) {
            this.supplement = this.code.substring(11, 13);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 14) {
            this.supplement = this.code.substring(12, 14);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 16) {
            this.supplement = this.code.substring(11, 16);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        if (this.code.length() == 17) {
            this.supplement = this.code.substring(12, 17);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        string = this.code.substring(0, 11);
        string = string + this.UPCEANCheck(string);
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.leftGuardBar = this.currentX;
        int n3 = 0;
        while (n3 < string.length()) {
            String string2 = "" + string.charAt(n3);
            n = -1;
            if (n3 <= 5) {
                n = this.findChar(this.setUPCALeft, string2);
                this.paintChar(graphics, "wbwb", this.setUPCALeft[n][1], bl);
            } else {
                n = this.findChar(this.setUPCARight, string2);
                this.paintChar(graphics, "bwbw", this.setUPCARight[n][1], bl);
            }
            if (n3 == 5) {
                this.centerGuardBarStart = this.currentX;
                this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0, bl);
                this.centerGuardBarEnd = this.currentX;
            }
            ++n3;
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.endOfCode = this.currentX;
        this.codeText = string;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.supplement, bl);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.supplement, bl);
        }
    }

    protected void paintEAN13(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        String string = "";
        int n2 = 0;
        while (n2 < this.code.length()) {
            if (this.code.charAt(n2) < '0' || this.code.charAt(n2) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n2;
        }
        if (this.code.length() < 12) {
            return;
        }
        if (this.code.length() == 14) {
            this.supplement = this.code.substring(12, 14);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 15) {
            this.supplement = this.code.substring(13, 15);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 17) {
            this.supplement = this.code.substring(12, 17);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        if (this.code.length() == 18) {
            this.supplement = this.code.substring(13, 18);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        string = this.code.substring(0, 12);
        string = string + this.UPCEANCheck(string);
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.leftGuardBar = this.currentX;
        String string2 = this.setEANCode[new Integer("" + string.charAt(0))];
        n = this.findChar(this.setEANLeftA, "" + string.charAt(1));
        this.paintChar(graphics, "wbwb", this.setEANLeftA[n][1], bl);
        int n3 = 2;
        while (n3 < 12) {
            String string3 = "" + string.charAt(n3);
            n = -1;
            if (n3 <= 6) {
                String[][] stringArray = this.setEANLeftA;
                if (string2.charAt(n3 - 2) == 'B') {
                    stringArray = this.setEANLeftB;
                }
                n = this.findChar(stringArray, string3);
                this.paintChar(graphics, "wbwb", stringArray[n][1], bl);
            } else {
                n = this.findChar(this.setEANRight, string3);
                this.paintChar(graphics, "bwbw", this.setEANRight[n][1], bl);
            }
            if (n3 == 6) {
                this.centerGuardBarStart = this.currentX;
                this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0, bl);
                this.centerGuardBarEnd = this.currentX;
            }
            ++n3;
        }
        n = this.findChar(this.setEANRight, "" + string.charAt(12));
        this.paintChar(graphics, "bwbw", this.setEANRight[n][1], bl);
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.codeText = string;
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.supplement, bl);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.supplement, bl);
        }
    }

    private int findInArray(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].compareTo(string) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected void paintCode128(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        String string = this.code;
        this.codeText = this.code;
        char c = '\u0000';
        boolean bl2 = false;
        int n7 = 0;
        int n8 = this.code.length();
        if (this.processTilde) {
            string = "";
            n4 = 0;
            n3 = 0;
            n2 = 0;
            String string2 = "";
            n = 1;
            while (n <= n8) {
                if (n < n8 - 2 && this.code.charAt(n - 1) == '~' && this.code.charAt(n) == 'm') {
                    n4 = (this.code.charAt(n + 1) - 48) * 10 + (this.code.charAt(n + 2) - 48);
                    if (n - n4 < 1) {
                        n4 = n - 1;
                    }
                    n3 = n - 1 - n4;
                    n2 = n4 + n3;
                    String string3 = "";
                    int n9 = 0;
                    while (n9 < n8 - 4) {
                        if (this.code.charAt(n9) == '~' && n9 < n8 - 3 && Character.isDigit(this.code.charAt(n9 + 1)) && Character.isDigit(this.code.charAt(n9 + 2)) && Character.isDigit(this.code.charAt(n9 + 3))) {
                            n9 += 3;
                        } else {
                            string3 = string3 + this.code.charAt(n9);
                        }
                        ++n9;
                    }
                    String string4 = string3;
                    string2 = this.UPCEANCheck(string4);
                    string = string + string2;
                    n += 3;
                } else if (n < n8 - 2 && this.code.charAt(n - 1) == '~' && this.code.charAt(n) > '/' && this.code.charAt(n) < ':') {
                    n7 = (this.code.charAt(n) - 48) * 100 + (this.code.charAt(n + 1) - 48) * 10 + (this.code.charAt(n + 2) - 48);
                    if (n7 > -1 && n7 < 255) {
                        string = string + (char)n7;
                        n += 3;
                    } else {
                        string = string + this.code.charAt(n - 1);
                    }
                } else {
                    string = string + this.code.charAt(n - 1);
                }
                ++n;
            }
            n7 = 0;
            this.code = string;
            string = "";
            n8 = this.code.length();
        }
        if (this.barType == 17 && this.code.charAt(0) != '\u00ca' && (this.code.charAt(0) < '\u00d4' || this.code.charAt(0) > '\u00d9')) {
            this.code = '\u00ca' + this.code;
        }
        n8 = this.code.length();
        String[] stringArray = this.set128B;
        n4 = 103;
        if (this.Code128Set != '0') {
            string = "";
            this.codeText = "";
            n3 = 1;
            while (n3 <= n8) {
                c = this.code.charAt(n3 - 1);
                if (c < ' ' && c >= '\u0000') {
                    if (this.Code128Set == 'A') {
                        string = string + (char)(c + 96);
                    }
                    if (this.Code128Set == 'B') {
                        if (this.code.charAt(n3) < ' ') {
                            string = string + '\u00c9' + (char)(c + 96) + (char)(this.code.charAt(n3) + 96) + '\u00c8';
                            ++n3;
                        } else {
                            string = string + '\u00c9' + (char)(c + 96) + '\u00c8';
                        }
                    }
                    if (this.Code128Set == 'C') {
                        if (this.code.charAt(n3) < ' ') {
                            string = string + '\u00c9' + '\u00c9' + (c + 64) + (this.code.charAt(n3) + 64) + "99";
                            ++n3;
                        } else {
                            string = string + '\u00c9' + '\u00c9' + (c + 64) + "99";
                        }
                    }
                    if (c == '\r' || c == '\t') {
                        this.codeText = this.codeText + "  ";
                    }
                } else {
                    this.codeText = this.codeText + (char)c;
                    string = string + (char)c;
                }
                ++n3;
            }
        }
        if (this.Code128Set == '0') {
            stringArray = this.set128B;
            this.codeText = "";
            string = "";
            n3 = 204;
            n2 = 66;
            n7 = this.code.charAt(0);
            if (n7 < 32) {
                n3 = 203;
            }
            if (n7 > 31 && n7 < 127) {
                n3 = 204;
            }
            if (n8 > 3 && n7 > 47 && n7 < 58 && this.code.charAt(1) > '/' && this.code.charAt(1) < ':' && this.code.charAt(2) > '/' && this.code.charAt(2) < ':' && this.code.charAt(3) > '/' && this.code.charAt(3) < ':') {
                n3 = 205;
            }
            if (n7 == 197) {
                n3 = 204;
            }
            if (n7 == 202 || n7 > 211) {
                n3 = 205;
            }
            if (n3 == 203) {
                n2 = 65;
                n4 = 103;
                this.paintChar(graphics, "bwbwbw", "211412", bl);
            }
            if (n3 == 204) {
                n2 = 66;
                n4 = 104;
                this.paintChar(graphics, "bwbwbw", "211214", bl);
            }
            if (n3 == 205) {
                n2 = 67;
                n4 = 105;
                this.paintChar(graphics, "bwbwbw", "211232", bl);
            }
            int n10 = 1;
            while (n10 <= n8) {
                n7 = this.code.charAt(n10 - 1);
                if (n10 < n8 - 1 && (n7 == 202 || n7 > 211)) {
                    string = string + '\u00ca';
                } else if (n7 == 197) {
                    if (n2 == 67) {
                        string = string + '\u00c8';
                        n2 = 66;
                    }
                    string = string + '\u00c5';
                } else if (n10 <= n8 - 3 && n7 > 47 && n7 < 58 && this.code.charAt(n10) > '/' && this.code.charAt(n10) < ':' && this.code.charAt(n10 + 1) > '/' && this.code.charAt(n10 + 1) < ':' && this.code.charAt(n10 + 2) > '/' && this.code.charAt(n10 + 2) < ':' || n10 <= n8 - 1 && n7 > 47 && n7 < 58 && this.code.charAt(n10) > '/' && this.code.charAt(n10) < ':' && n2 == 67) {
                    if (n2 != 67) {
                        n = n10;
                        int n11 = 3;
                        while (n <= n8 && this.isDigit(this.code.charAt(n - 1))) {
                            n11 = 4 - n11;
                            ++n;
                        }
                        if (n11 == 1) {
                            string = string + this.code.charAt(n10 - 1);
                            ++n10;
                        }
                        n11 = 0;
                    }
                    if (n2 != 67) {
                        string = string + '\u00c7';
                        n2 = 67;
                    }
                    if ((n7 = (this.code.charAt(n10 - 1) - 48) * 10 + (this.code.charAt(n10) - 48)) < 95 && n7 >= 0) {
                        string = string + (char)(n7 + 32);
                    } else if (n7 > 94) {
                        string = string + (char)(n7 + 100);
                    }
                    ++n10;
                } else if (n10 <= n8 && (n7 < 32 || n2 == 65 && n7 < 96)) {
                    if (n2 != 65) {
                        string = string + '\u00c9';
                        n2 = 65;
                    }
                    if (n7 < 32) {
                        string = string + (char)(n7 + 96);
                    } else if (n7 > 31) {
                        string = string + (char)n7;
                    }
                } else if (n10 <= n8 && n7 > 31 && n7 < 127) {
                    if (n2 != 66) {
                        string = string + '\u00c8';
                        n2 = 66;
                    }
                    string = string + (char)n7;
                }
                ++n10;
            }
            n = 1;
            while (n <= n8) {
                n7 = this.code.charAt(n - 1);
                bl2 = false;
                if (n < n8 - 1 && (n7 == 202 || n7 > 211)) {
                    n7 = (this.code.charAt(n) - 48) * 10 + (this.code.charAt(n + 1) - 48);
                    if (this.code.charAt(n - 1) == '\u00d4') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + ") ";
                        n += 2;
                        bl2 = true;
                    } else if (n < n8 - 2 && this.code.charAt(n - 1) == '\u00d5') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + ") ";
                        n += 3;
                        bl2 = true;
                    } else if (n < n8 - 3 && this.code.charAt(n - 1) == '\u00d6') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                        bl2 = true;
                    } else if (n < n8 - 4 && this.code.charAt(n - 1) == '\u00d7') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + ") ";
                        n += 5;
                        bl2 = true;
                    } else if (n < n8 - 5 && this.code.charAt(n - 1) == '\u00d8') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + this.code.charAt(n + 5) + ") ";
                        n += 6;
                        bl2 = true;
                    } else if (n < n8 - 6 && this.code.charAt(n - 1) == '\u00d9') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + this.code.charAt(n + 5) + this.code.charAt(n + 6) + ") ";
                        n += 7;
                        bl2 = true;
                    } else if (n7 <= 30 && n7 >= 0 || n7 <= 99 && n7 >= 90) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + ") ";
                        n += 2;
                        bl2 = true;
                    } else if (n < n8 - 2 && (n7 <= 49 && n7 >= 40 || n7 <= 25 && n7 >= 23)) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + ") ";
                        n += 3;
                        bl2 = true;
                    } else if (n < n8 - 3 && (n7 <= 81 && n7 >= 80 || n7 <= 34 && n7 >= 31)) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                        bl2 = true;
                    } else if (n < n8 - 3 && !bl2) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                    }
                } else if (this.code.charAt(n - 1) < ' ') {
                    this.codeText = this.codeText + " ";
                } else if (this.code.charAt(n - 1) == '\u00c5') {
                    this.codeText = this.codeText + " ";
                } else if (this.code.charAt(n - 1) > '\u001f' && this.code.charAt(n - 1) < '\u0080') {
                    this.codeText = this.codeText + this.code.charAt(n - 1);
                }
                ++n;
            }
        }
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
            n4 = 104;
        }
        if (this.Code128Set == 'C') {
            stringArray = this.set128C;
            n4 = 105;
            if (string.length() % 2 == 1) {
                this.codeText = string = "0" + string;
            }
        }
        if (this.Code128Set == 'B') {
            this.paintChar(graphics, "bwbwbw", "211214", bl);
        }
        if (this.Code128Set == 'C') {
            this.paintChar(graphics, "bwbwbw", "211232", bl);
        }
        if (this.Code128Set == 'A') {
            this.paintChar(graphics, "bwbwbw", "211412", bl);
        }
        n3 = 1;
        n2 = 0;
        while (n2 < string.length()) {
            String string5 = "" + string.charAt(n2);
            if (this.Code128Set == 'C') {
                String string6 = "" + string5;
                if (++n2 < string.length()) {
                    string6 = string6 + string.charAt(n2);
                }
                if ((n5 = this.findInArray(this.set128C, string6)) >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n5], bl);
                    n4 += n5 * n3;
                }
            } else {
                n5 = this.findInArray(stringArray, string5);
                if (n5 >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n5], bl);
                    n4 += n5 * n3;
                }
            }
            ++n3;
            ++n2;
        }
        if (this.checkCharacter) {
            n6 = (int)BarCode.mod(n4, 103.0);
            this.paintChar(graphics, "bwbwbw", this.set128[n6], bl);
        }
        this.paintChar(graphics, "bwbwbwb", "2331112", bl);
    }

    protected void paintUCC128(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        this.setCode128Set("AUTO");
        int n5 = 0;
        int n6 = 0;
        String string = this.code;
        this.codeText = this.code;
        char c = '\u0000';
        boolean bl2 = false;
        int n7 = 0;
        int n8 = this.code.length();
        if (this.processTilde) {
            string = "";
            n4 = 0;
            n3 = 0;
            n2 = 0;
            String string2 = "";
            n = 1;
            while (n <= n8) {
                if (n < n8 - 2 && this.code.charAt(n - 1) == '~' && this.code.charAt(n) == 'm') {
                    n4 = (this.code.charAt(n + 1) - 48) * 10 + (this.code.charAt(n + 2) - 48);
                    if (n - n4 < 1) {
                        n4 = n - 1;
                    }
                    n3 = n - 1 - n4;
                    n2 = n4 + n3;
                    String string3 = this.code.substring(n3, n2);
                    string2 = this.UPCEANCheck(string3);
                    string = string + string2;
                    n += 3;
                } else if (n < n8 - 2 && this.code.charAt(n - 1) == '~' && this.code.charAt(n) > '/' && this.code.charAt(n) < ':') {
                    n7 = (this.code.charAt(n) - 48) * 100 + (this.code.charAt(n + 1) - 48) * 10 + (this.code.charAt(n + 2) - 48);
                    if (n7 > -1 && n7 < 255) {
                        string = string + (char)n7;
                        n += 3;
                    } else {
                        string = string + this.code.charAt(n - 1);
                    }
                } else {
                    string = string + this.code.charAt(n - 1);
                }
                ++n;
            }
            n7 = 0;
            this.code = string;
            string = "";
        }
        if (this.code.charAt(0) < '\u00ca') {
            this.code = '\u00ca' + this.code;
        }
        n8 = this.code.length();
        String[] stringArray = this.set128B;
        n4 = 103;
        if (this.Code128Set != '0') {
            string = "";
            this.codeText = "";
            n3 = 1;
            while (n3 <= n8) {
                c = this.code.charAt(n3 - 1);
                if (c < ' ' && c >= '\u0000') {
                    if (this.Code128Set == 'A') {
                        string = string + (char)(c + 96);
                    }
                    if (this.Code128Set == 'B') {
                        if (this.code.charAt(n3) < ' ') {
                            string = string + '\u00c9' + (char)(c + 96) + (char)(this.code.charAt(n3) + 96) + '\u00c8';
                            ++n3;
                        } else {
                            string = string + '\u00c9' + (char)(c + 96) + '\u00c8';
                        }
                    }
                    if (this.Code128Set == 'C') {
                        if (this.code.charAt(n3) < ' ') {
                            string = string + '\u00c9' + '\u00c9' + (c + 64) + (this.code.charAt(n3) + 64) + "99";
                            ++n3;
                        } else {
                            string = string + '\u00c9' + '\u00c9' + (c + 64) + "99";
                        }
                    }
                    if (c == '\r' || c == '\t') {
                        this.codeText = this.codeText + "  ";
                    }
                } else {
                    this.codeText = this.codeText + (char)c;
                    string = string + (char)c;
                }
                ++n3;
            }
        }
        if (this.Code128Set == '0') {
            stringArray = this.set128B;
            this.codeText = "";
            string = "";
            n3 = 204;
            n2 = 66;
            n7 = this.code.charAt(0);
            if (n7 < 32) {
                n3 = 203;
            }
            if (n7 > 31 && n7 < 127) {
                n3 = 204;
            }
            if (n8 > 3 && n7 > 47 && n7 < 58 && this.code.charAt(1) > '/' && this.code.charAt(1) < ':' && this.code.charAt(2) > '/' && this.code.charAt(2) < ':' && this.code.charAt(3) > '/' && this.code.charAt(3) < ':') {
                n3 = 205;
            }
            if (n7 == 202 || n7 > 211) {
                n3 = 205;
            }
            if (n3 == 203) {
                n2 = 65;
                n4 = 103;
                this.paintChar(graphics, "bwbwbw", "211412", bl);
            }
            if (n3 == 204) {
                n2 = 66;
                n4 = 104;
                this.paintChar(graphics, "bwbwbw", "211214", bl);
            }
            if (n3 == 205) {
                n2 = 67;
                n4 = 105;
                this.paintChar(graphics, "bwbwbw", "211232", bl);
            }
            int n9 = 1;
            while (n9 <= n8) {
                n7 = this.code.charAt(n9 - 1);
                if (n9 < n8 - 1 && (n7 == 202 || n7 > 211)) {
                    string = string + '\u00ca';
                } else if (n7 == 197) {
                    if (n2 == 67) {
                        string = string + '\u00c8';
                        n2 = 66;
                    }
                    string = string + '\u00c5';
                } else if (n9 <= n8 - 3 && n7 > 47 && n7 < 58 && this.code.charAt(n9) > '/' && this.code.charAt(n9) < ':' && this.code.charAt(n9 + 1) > '/' && this.code.charAt(n9 + 1) < ':' && this.code.charAt(n9 + 2) > '/' && this.code.charAt(n9 + 2) < ':' || n9 <= n8 - 1 && n7 > 47 && n7 < 58 && this.code.charAt(n9) > '/' && this.code.charAt(n9) < ':' && n2 == 67) {
                    if (n2 != 67) {
                        n = n9;
                        int n10 = 3;
                        while (n <= n8 && this.isDigit(this.code.charAt(n - 1))) {
                            n10 = 4 - n10;
                            ++n;
                        }
                        if (n10 == 1) {
                            string = string + this.code.charAt(n9 - 1);
                            ++n9;
                        }
                        n10 = 0;
                    }
                    if (n2 != 67) {
                        string = string + '\u00c7';
                        n2 = 67;
                    }
                    if ((n7 = (this.code.charAt(n9 - 1) - 48) * 10 + (this.code.charAt(n9) - 48)) < 95 && n7 >= 0) {
                        string = string + (char)(n7 + 32);
                    } else if (n7 > 94) {
                        string = string + (char)(n7 + 100);
                    }
                    ++n9;
                } else if (n9 <= n8 && (n7 < 32 || n2 == 65 && n7 < 96)) {
                    if (n2 != 65) {
                        string = string + '\u00c9';
                        n2 = 65;
                    }
                    if (n7 < 32) {
                        string = string + (char)(n7 + 96);
                    } else if (n7 > 31) {
                        string = string + (char)n7;
                    }
                } else if (n9 <= n8 && n7 > 31 && n7 < 127) {
                    if (n2 != 66) {
                        string = string + '\u00c8';
                        n2 = 66;
                    }
                    string = string + (char)n7;
                }
                ++n9;
            }
            n = 1;
            while (n <= n8) {
                n7 = this.code.charAt(n - 1);
                bl2 = false;
                if (n < n8 - 1 && (n7 == 202 || n7 > 211)) {
                    n7 = (this.code.charAt(n) - 48) * 10 + (this.code.charAt(n + 1) - 48);
                    if (this.code.charAt(n - 1) == '\u00d4') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + ") ";
                        n += 2;
                        bl2 = true;
                    } else if (n < n8 - 2 && this.code.charAt(n - 1) == '\u00d5') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + ") ";
                        n += 3;
                        bl2 = true;
                    } else if (n < n8 - 3 && this.code.charAt(n - 1) == '\u00d6') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                        bl2 = true;
                    } else if (n < n8 - 4 && this.code.charAt(n - 1) == '\u00d7') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + ") ";
                        n += 5;
                        bl2 = true;
                    } else if (n < n8 - 5 && this.code.charAt(n - 1) == '\u00d8') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + this.code.charAt(n + 5) + ") ";
                        n += 6;
                        bl2 = true;
                    } else if (n < n8 - 6 && this.code.charAt(n - 1) == '\u00d9') {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + this.code.charAt(n + 4) + this.code.charAt(n + 5) + this.code.charAt(n + 6) + ") ";
                        n += 7;
                        bl2 = true;
                    } else if (n7 <= 30 && n7 >= 0 || n7 <= 99 && n7 >= 90) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + ") ";
                        n += 2;
                        bl2 = true;
                    } else if (n < n8 - 2 && (n7 <= 49 && n7 >= 40 || n7 <= 25 && n7 >= 23)) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + ") ";
                        n += 3;
                        bl2 = true;
                    } else if (n < n8 - 3 && (n7 <= 81 && n7 >= 80 || n7 <= 34 && n7 >= 31)) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                        bl2 = true;
                    } else if (n < n8 - 3 && !bl2) {
                        this.codeText = this.codeText + " (" + this.code.charAt(n) + this.code.charAt(n + 1) + this.code.charAt(n + 2) + this.code.charAt(n + 3) + ") ";
                        n += 4;
                    }
                } else if (this.code.charAt(n - 1) < ' ') {
                    this.codeText = this.codeText + " ";
                } else if (this.code.charAt(n - 1) > '\u001f' && this.code.charAt(n - 1) < '\u0080') {
                    this.codeText = this.codeText + this.code.charAt(n - 1);
                }
                ++n;
            }
        }
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
            n4 = 104;
        }
        if (this.Code128Set == 'C') {
            stringArray = this.set128C;
            n4 = 105;
            if (string.length() % 2 == 1) {
                this.codeText = string = "0" + string;
            }
        }
        if (this.Code128Set == 'B') {
            this.paintChar(graphics, "bwbwbw", "211214", bl);
        }
        if (this.Code128Set == 'C') {
            this.paintChar(graphics, "bwbwbw", "211232", bl);
        }
        if (this.Code128Set == 'A') {
            this.paintChar(graphics, "bwbwbw", "211412", bl);
        }
        n3 = 1;
        n2 = 0;
        while (n2 < string.length()) {
            String string4 = "" + string.charAt(n2);
            if (this.Code128Set == 'C') {
                String string5 = "" + string4;
                if (++n2 < string.length()) {
                    string5 = string5 + string.charAt(n2);
                }
                if ((n5 = this.findInArray(this.set128C, string5)) >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n5], bl);
                    n4 += n5 * n3;
                }
            } else {
                n5 = this.findInArray(stringArray, string4);
                if (n5 >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n5], bl);
                    n4 += n5 * n3;
                }
            }
            ++n3;
            ++n2;
        }
        if (this.checkCharacter) {
            n6 = (int)BarCode.mod(n4, 103.0);
            this.paintChar(graphics, "bwbwbw", this.set128[n6], bl);
        }
        this.paintChar(graphics, "bwbwbwb", "2331112", bl);
    }

    protected void paintEAN8(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        String string = "";
        int n2 = 0;
        while (n2 < this.code.length()) {
            if (this.code.charAt(n2) < '0' || this.code.charAt(n2) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n2;
        }
        if (this.code.length() < 7) {
            return;
        }
        if (this.code.length() == 9) {
            this.supplement = this.code.substring(7, 9);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 10) {
            this.supplement = this.code.substring(8, 10);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 12) {
            this.supplement = this.code.substring(7, 12);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        if (this.code.length() == 13) {
            this.supplement = this.code.substring(8, 13);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        string = this.code.substring(0, 7);
        string = string + this.UPCEANCheck(string);
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.leftGuardBar = this.currentX;
        int n3 = 0;
        while (n3 < string.length()) {
            String string2 = "" + string.charAt(n3);
            n = -1;
            if (n3 <= 3) {
                n = this.findChar(this.setEANLeftA, string2);
                this.paintChar(graphics, "wbwb", this.setEANLeftA[n][1], bl);
            } else {
                n = this.findChar(this.setEANRight, string2);
                this.paintChar(graphics, "bwbw", this.setEANRight[n][1], bl);
            }
            if (n3 == 3) {
                this.centerGuardBarStart = this.currentX;
                this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0, bl);
                this.centerGuardBarEnd = this.currentX;
            }
            ++n3;
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.endOfCode = this.currentX;
        this.codeText = string;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.supplement, bl);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.supplement, bl);
        }
    }

    protected void paintUPCE(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        String string = "";
        String string2 = "";
        int n3 = 0;
        while (n3 < this.code.length()) {
            if (this.code.charAt(n3) < '0' || this.code.charAt(n3) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n3;
        }
        if (this.code.length() == 13) {
            this.supplement = this.code.substring(11, 13);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 14) {
            this.supplement = this.code.substring(12, 14);
            this.UPCEANSupplement2 = true;
            this.UPCEANSupplement5 = false;
        }
        if (this.code.length() == 16) {
            this.supplement = this.code.substring(11, 16);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        if (this.code.length() == 17) {
            this.supplement = this.code.substring(12, 17);
            this.UPCEANSupplement5 = true;
            this.UPCEANSupplement2 = false;
        }
        if (this.code.length() == 6 || this.code.length() == 7) {
            this.code = this.UPCe7To11(this.code);
        }
        if (this.code.length() == 8) {
            this.code = this.UPCe7To11(this.code.substring(0, 7));
        }
        if (this.code.length() < 11) {
            return;
        }
        string2 = this.code.substring(0, 11);
        string2 = string2 + this.UPCEANCheck(string2);
        n2 = new Integer("" + string2.charAt(11));
        if (string2.substring(3, 6).compareTo("000") == 0 || string2.substring(3, 6).compareTo("100") == 0 || string2.substring(3, 6).compareTo("200") == 0) {
            string = string2.substring(1, 3) + string2.substring(8, 11) + string2.charAt(3);
        }
        if (string2.substring(3, 6).compareTo("300") == 0 || string2.substring(3, 6).compareTo("400") == 0 || string2.substring(3, 6).compareTo("500") == 0 || string2.substring(3, 6).compareTo("600") == 0 || string2.substring(3, 6).compareTo("700") == 0 || string2.substring(3, 6).compareTo("800") == 0 || string2.substring(3, 6).compareTo("900") == 0) {
            string = string2.substring(1, 4) + string2.substring(9, 11) + "3";
        }
        if (string2.substring(4, 6).compareTo("10") == 0 || string2.substring(4, 6).compareTo("20") == 0 || string2.substring(4, 6).compareTo("30") == 0 || string2.substring(4, 6).compareTo("40") == 0 || string2.substring(4, 6).compareTo("50") == 0 || string2.substring(4, 6).compareTo("60") == 0 || string2.substring(4, 6).compareTo("70") == 0 || string2.substring(4, 6).compareTo("80") == 0 || string2.substring(4, 6).compareTo("90") == 0) {
            string = string2.substring(1, 5) + string2.substring(10, 11) + "4";
        }
        if (string2.substring(5, 6).compareTo("0") != 0) {
            string = string2.substring(1, 6) + string2.substring(10, 11);
        }
        this.paintGuardChar(graphics, "bwb", "nnn", 0, bl);
        this.leftGuardBar = this.currentX;
        String string3 = this.UPCESystem0[n2];
        this.codeText = "0" + string + n2;
        if (this.UPCESytem == '1') {
            string3 = this.UPCESystem1[n2];
            this.codeText = "1" + string + n2;
        }
        if (this.UPCESytem == '2') {
            if (string2.substring(0, 1).equals("0")) {
                string3 = this.UPCESystem0[n2];
                this.codeText = "0" + string + n2;
            }
            if (string2.substring(0, 1).equals("1")) {
                string3 = this.UPCESystem1[n2];
                this.codeText = "1" + string + n2;
            }
        }
        int n4 = 0;
        while (n4 < string.length()) {
            String string4 = "" + string.charAt(n4);
            n = -1;
            String[][] stringArray = this.setUPCEOdd;
            if (string3.charAt(n4) == 'E') {
                stringArray = this.setUPCEEven;
            }
            n = this.findChar(stringArray, string4);
            this.paintChar(graphics, "wbwb", stringArray[n][1], bl);
            ++n4;
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "wbwbwb", "nnnnnn", 0, bl);
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.supplement, bl);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.supplement, bl);
        }
    }

    protected void paintSup2(Graphics graphics, String string, boolean bl) {
        int n;
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        this.suplementTopMargin = (int)((double)this.barHeightPixels * (1.0 - this.supHeight));
        this.codeSup = string;
        if (string.length() != 2) {
            return;
        }
        this.startSuplement = this.currentX = (int)((double)this.currentX + (double)this.resolution * this.supSeparationCM);
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        String string2 = "OO";
        if (BarCode.mod(n, 4.0) == 1.0) {
            string2 = "OE";
        }
        if (BarCode.mod(n, 4.0) == 2.0) {
            string2 = "EO";
        }
        if (BarCode.mod(n, 4.0) == 3.0) {
            string2 = "EE";
        }
        this.paintGuardChar(graphics, "bwb", "112", this.suplementTopMargin, bl);
        String[][] stringArray = this.setUPCEOdd;
        if (string2.charAt(0) == 'E') {
            stringArray = this.setUPCEEven;
        }
        int n2 = this.findChar(stringArray, "" + string.charAt(0));
        this.paintGuardChar(graphics, "wbwb", stringArray[n2][1], this.suplementTopMargin, bl);
        this.paintGuardChar(graphics, "wb", "11", this.suplementTopMargin, bl);
        stringArray = this.setUPCEOdd;
        if (string2.charAt(1) == 'E') {
            stringArray = this.setUPCEEven;
        }
        n2 = this.findChar(stringArray, "" + string.charAt(1));
        this.paintGuardChar(graphics, "wbwb", stringArray[n2][1], this.suplementTopMargin, bl);
        this.endSuplement = this.currentX;
    }

    protected void paintSup5(Graphics graphics, String string, boolean bl) {
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        this.suplementTopMargin = (int)((double)this.barHeightPixels * (1.0 - this.supHeight));
        this.codeSup = string;
        if (string.length() != 5) {
            return;
        }
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            if (bl2) {
                n += new Integer("" + string.charAt(n3)).intValue();
            } else {
                n2 += new Integer("" + string.charAt(n3)).intValue();
            }
            bl2 = !bl2;
            --n3;
        }
        n2 = n * 3 + n2 * 9;
        String string2 = "" + n2;
        int n4 = new Integer("" + string2.charAt(string2.length() - 1));
        String string3 = this.fiveSuplement[n4];
        this.startSuplement = this.currentX = (int)((double)this.currentX + (double)this.resolution * this.supSeparationCM);
        this.paintGuardChar(graphics, "bwb", "112", this.suplementTopMargin, bl);
        String[][] stringArray = null;
        int n5 = 0;
        while (n5 < 5) {
            stringArray = this.setUPCEOdd;
            if (string3.charAt(n5) == 'E') {
                stringArray = this.setUPCEEven;
            }
            int n6 = this.findChar(stringArray, "" + string.charAt(n5));
            this.paintGuardChar(graphics, "wbwb", stringArray[n6][1], this.suplementTopMargin, bl);
            if (n5 < 4) {
                this.paintGuardChar(graphics, "wb", "11", this.suplementTopMargin, bl);
            }
            ++n5;
        }
        this.endSuplement = this.currentX;
    }

    protected void paintMAT25(Graphics graphics, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        String string = this.code;
        this.paintChar(graphics, "bwbwbw", "wnnnnn", bl);
        int n2 = 0;
        while (n2 < string.length()) {
            String string2 = "" + this.code.charAt(n2);
            n = this.findChar(this.set25, string2);
            if (n >= 0) {
                this.paintChar(graphics, "bwbwbw", this.set25[n][1] + "n", bl);
            }
            ++n2;
        }
        this.paintChar(graphics, "bwbwbw", "wnnnnn", bl);
    }

    protected void paintCODE39(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        this.code = this.code.toUpperCase();
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1], bl);
        this.currentX += this.narrowBarPixels;
        int n3 = 0;
        while (n3 < this.code.length()) {
            String string = "" + this.code.charAt(n3);
            n = this.findChar(this.set39, string);
            if (n > -1) {
                n2 += n;
                this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1], bl);
                this.currentX += this.narrowBarPixels;
            }
            ++n3;
        }
        if (this.checkCharacter) {
            n = (int)BarCode.mod(n2, 43.0);
            this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1], bl);
            this.currentX += this.narrowBarPixels;
            this.codeText = this.checkCharacterInText ? this.code + "" + this.set39[n][0] : this.code;
        }
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1], bl);
    }

    protected void paintCODE11(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        this.paintChar(graphics, "bwbwbw", "nnwwnn", bl);
        int n3 = 1;
        n2 = 0;
        int n4 = this.code.length() - 1;
        while (n4 >= 0) {
            n2 += this.findChar(this.set11, "" + this.code.charAt(n4)) * n3;
            if (++n3 == 11) {
                n3 = 1;
            }
            --n4;
        }
        int n5 = (int)BarCode.mod(n2, 11.0);
        n3 = 2;
        n2 = n5;
        int n6 = this.code.length() - 1;
        while (n6 >= 0) {
            n2 += this.findChar(this.set11, "" + this.code.charAt(n6)) * n3;
            if (++n3 == 10) {
                n3 = 1;
            }
            --n6;
        }
        int n7 = (int)BarCode.mod(n2, 11.0);
        int n8 = 0;
        while (n8 < this.code.length()) {
            String string = "" + this.code.charAt(n8);
            n = this.findChar(this.set11, string);
            if (n > -1) {
                this.paintChar(graphics, "bwbwbw", this.set11[n][1] + "n", bl);
            }
            ++n8;
        }
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbw", this.set11[n5][1] + "n", bl);
            this.codeText = this.checkCharacterInText ? this.code + this.set11[n5][0] : this.code;
            if (this.code.length() > 10) {
                this.paintChar(graphics, "bwbwbw", this.set11[n7][1] + "n", bl);
                this.codeText = this.checkCharacterInText ? this.codeText + this.set11[n7][0] : this.code;
            }
        }
        this.paintChar(graphics, "bwbwbw", "nnwwnn", bl);
    }

    protected void paintCODABAR(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[this.findChar(this.setCODABAR, "" + this.CODABARStartChar)][1] + "n", bl);
        n2 = this.findChar(this.setCODABAR, "" + this.CODABARStartChar) + this.findChar(this.setCODABAR, "" + this.CODABARStopChar);
        int n3 = this.code.length() - 1;
        while (n3 >= 0) {
            n2 += this.findChar(this.setCODABAR, "" + this.code.charAt(n3));
            --n3;
        }
        int n4 = (int)BarCode.mod(n2, 16.0);
        if (n4 != 0) {
            n4 = 16 - n4;
        }
        int n5 = 0;
        while (n5 < this.code.length()) {
            String string = "" + this.code.charAt(n5);
            n = this.findChar(this.setCODABAR, string);
            if (n > -1) {
                this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[n][1] + "n", bl);
            }
            ++n5;
        }
        if (this.checkCharacter) {
            this.codeText = this.checkCharacterInText ? this.code + this.setCODABAR[n4][0] : this.code;
            this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[n4][1] + "n", bl);
        }
        this.paintChar(graphics, "bwbwbwb", this.setCODABAR[this.findChar(this.setCODABAR, "" + this.CODABARStopChar)][1], bl);
    }

    protected void paintMSI(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.code.length()) {
            if (this.code.charAt(n3) < '0' || this.code.charAt(n3) > '9') {
                this.codeText = "Incorrect Data To Encode";
                return;
            }
            ++n3;
        }
        this.paintChar(graphics, "bw", "wn", bl);
        n2 = 0;
        String string = "";
        boolean bl2 = true;
        int n4 = this.code.length() - 1;
        while (n4 >= 0) {
            if (!bl2) {
                n2 += this.findChar(this.setMSI, "" + this.code.charAt(n4));
            }
            if (bl2) {
                string = this.findChar(this.setMSI, "" + this.code.charAt(n4)) + string;
            }
            bl2 = !bl2;
            --n4;
        }
        string = "" + new Long(string) * 2L;
        int n5 = string.length() - 1;
        while (n5 >= 0) {
            n2 += this.findChar(this.setMSI, "" + string.charAt(n5));
            --n5;
        }
        int n6 = (int)BarCode.mod(n2, 10.0);
        if (n6 != 0) {
            n6 = 10 - n6;
        }
        int n7 = 0;
        while (n7 < this.code.length()) {
            String string2 = "" + this.code.charAt(n7);
            n = this.findChar(this.setMSI, string2);
            if (n > -1) {
                this.paintChar(graphics, "bwbwbwbw", this.setMSI[n][1], bl);
            }
            ++n7;
        }
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbwb", this.setMSI[n6][1], bl);
            this.codeText = this.checkCharacterInText ? this.code + this.setMSI[n6][0] : this.code;
        }
        this.paintChar(graphics, "wbwb", "nnwn", bl);
    }

    protected static double mod(double d, double d2) {
        double d3 = d / d2;
        double d4 = Math.round(d3);
        if (d4 > d3) {
            d4 -= 1.0;
        }
        return d - d2 * d4;
    }

    protected void paintCODE39Ext(Graphics graphics, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1], bl);
        this.currentX += this.narrowBarPixels;
        int n4 = 0;
        while (n4 < this.code.length()) {
            byte by = (byte)this.code.charAt(n4);
            if (by <= 128) {
                String string = this.set39Ext[by];
                n = 0;
                while (n < string.length()) {
                    String string2 = "" + string.charAt(n);
                    n2 = this.findChar(this.set39, string2);
                    if (n2 > -1) {
                        n3 += n2;
                        this.paintChar(graphics, "bwbwbwbwb", this.set39[n2][1], bl);
                        this.currentX += this.narrowBarPixels;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        this.codeText = "";
        n = 0;
        int n5 = 1;
        while (n5 <= this.code.length()) {
            n = this.code.charAt(n5 - 1);
            if (n < 32 && n >= 0) {
                if (n == 13 || n == 9) {
                    this.codeText = this.codeText + "  ";
                }
            } else {
                this.codeText = this.codeText + (char)n;
            }
            ++n5;
        }
        if (this.checkCharacter) {
            n2 = (int)BarCode.mod(n3, 43.0);
            this.paintChar(graphics, "bwbwbwbwb", this.set39[n2][1], bl);
            this.currentX += this.narrowBarPixels;
            if (this.checkCharacterInText) {
                this.codeText = this.codeText + "" + this.set39[n2][0];
            }
        }
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1], bl);
    }

    protected void paintBAR93(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.code = this.code.toUpperCase();
        this.paintChar(graphics, "bwbwbw", "111141", bl);
        int n5 = 0;
        while (n5 < this.code.length()) {
            String string = "" + this.code.charAt(n5);
            n = this.findChar(this.set93, string);
            if (n > -1) {
                n2 += n;
                this.paintChar(graphics, "bwbwbw", this.set93[n][1], bl);
            }
            ++n5;
        }
        int n6 = 1;
        n2 = 0;
        int n7 = this.code.length() - 1;
        while (n7 >= 0) {
            n2 += this.findChar(this.set93, "" + this.code.charAt(n7)) * n6;
            if (++n6 == 21) {
                n6 = 1;
            }
            --n7;
        }
        n4 = (int)BarCode.mod(n2, 47.0);
        n6 = 2;
        n2 = n4;
        int n8 = this.code.length() - 1;
        while (n8 >= 0) {
            n2 += this.findChar(this.set93, "" + this.code.charAt(n8)) * n6;
            if (++n6 == 16) {
                n6 = 1;
            }
            --n8;
        }
        n3 = (int)BarCode.mod(n2, 47.0);
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbw", this.set93[n4][1], bl);
            this.paintChar(graphics, "bwbwbw", this.set93[n3][1], bl);
            this.codeText = this.checkCharacterInText ? this.code + this.set93[n4][0] + this.set93[n3][0] : this.code;
        }
        this.paintChar(graphics, "bwbwbwb", "1111411", bl);
        String string = "";
        int n9 = 0;
        while (n9 < this.codeText.length()) {
            if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '1') {
                string = string + "!";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '2') {
                string = string + "#";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '3') {
                string = string + "&";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '4') {
                string = string + "@";
                ++n9;
            } else {
                string = string + this.codeText.charAt(n9);
            }
            ++n9;
        }
        this.codeText = string;
    }

    protected void paintBAR93Ext(Graphics graphics, boolean bl) {
        String string;
        String string2;
        byte by;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.paintChar(graphics, "bwbwbw", "111141", bl);
        int n5 = 0;
        while (n5 < this.code.length()) {
            by = (byte)this.code.charAt(n5);
            if (by <= 128) {
                string2 = this.set93Ext[by];
                if (string2.length() == 3) {
                    string = "" + string2.charAt(0) + string2.charAt(1);
                    n = this.findChar(this.set93, string);
                    this.paintChar(graphics, "bwbwbw", this.set93[n][1], bl);
                    string = "" + string2.charAt(2);
                } else {
                    string = "" + string2.charAt(0);
                }
                n = this.findChar(this.set93, string);
                n2 += n;
                this.paintChar(graphics, "bwbwbw", this.set93[n][1], bl);
            }
            ++n5;
        }
        int n6 = 1;
        n2 = 0;
        int n7 = this.code.length() - 1;
        while (n7 >= 0) {
            by = (byte)this.code.charAt(n7);
            if (by <= 128) {
                string2 = this.set93Ext[by];
                if (string2.length() == 3) {
                    string = "" + string2.charAt(0) + string2.charAt(1);
                    n = this.findChar(this.set93, string);
                    n2 += n * (n6 + 1);
                    string = "" + string2.charAt(2);
                    n = this.findChar(this.set93, string);
                    n2 += n * n6;
                    if (++n6 == 21) {
                        n6 = 1;
                    }
                    if (++n6 == 21) {
                        n6 = 1;
                    }
                } else {
                    string = "" + string2.charAt(0);
                    n = this.findChar(this.set93, string);
                    n2 += n * n6;
                    if (++n6 == 21) {
                        n6 = 1;
                    }
                }
            }
            --n7;
        }
        n4 = (int)BarCode.mod(n2, 47.0);
        n6 = 2;
        n2 = n4;
        int n8 = this.code.length() - 1;
        while (n8 >= 0) {
            by = (byte)this.code.charAt(n8);
            if (by <= 128) {
                string2 = this.set93Ext[by];
                if (string2.length() == 3) {
                    string = "" + string2.charAt(0) + string2.charAt(1);
                    n = this.findChar(this.set93, string);
                    n2 += n * (n6 + 1);
                    string = "" + string2.charAt(2);
                    n = this.findChar(this.set93, string);
                    n2 += n * n6;
                    if (++n6 == 16) {
                        n6 = 1;
                    }
                    if (++n6 == 16) {
                        n6 = 1;
                    }
                } else {
                    string = "" + string2.charAt(0);
                    n = this.findChar(this.set93, string);
                    n2 += n * n6;
                    if (++n6 == 16) {
                        n6 = 1;
                    }
                }
            }
            --n8;
        }
        n3 = (int)BarCode.mod(n2, 47.0);
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbw", this.set93[n4][1], bl);
            this.paintChar(graphics, "bwbwbw", this.set93[n3][1], bl);
            this.codeText = this.checkCharacterInText ? this.code + this.set93[n4][0] + this.set93[n3][0] : this.code;
        }
        this.paintChar(graphics, "bwbwbwb", "1111411", bl);
        String string3 = this.codeText.substring(this.codeText.length() - 5);
        int n9 = this.codeText.length();
        while (n9 < this.codeText.length()) {
            if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '1') {
                string3 = string3 + "!";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '2') {
                string3 = string3 + "#";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '3') {
                string3 = string3 + "&";
                ++n9;
            } else if (this.codeText.charAt(n9) == '_' && this.codeText.charAt(n9 + 1) == '4') {
                string3 = string3 + "@";
                ++n9;
            } else {
                string3 = string3 + this.codeText.charAt(n9);
            }
            ++n9;
        }
        this.codeText = string3;
    }

    protected void paintChar(Graphics graphics, String string, String string2, boolean bl) {
        this.paintChar2(graphics, string, string2, 0, bl);
    }

    protected void paintChar2(Graphics graphics, String string, String string2, int n, boolean bl) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            char c2 = string2.charAt(n2);
            if (c2 == 'n') {
                this.addBar(graphics, this.narrowBarPixels, c == 'b', n, bl);
            }
            if (c2 == 'w') {
                this.addBar(graphics, this.widthBarPixels, c == 'b', n, bl);
            }
            if (c2 == '1') {
                this.addBar(graphics, this.narrowBarPixels, c == 'b', n, bl);
            }
            if (c2 == '2') {
                this.addBar(graphics, this.narrowBarPixels * 2, c == 'b', n, bl);
            }
            if (c2 == '3') {
                this.addBar(graphics, this.narrowBarPixels * 3, c == 'b', n, bl);
            }
            if (c2 == '4') {
                this.addBar(graphics, this.narrowBarPixels * 4, c == 'b', n, bl);
            }
            ++n2;
        }
    }

    protected void paintGuardChar(Graphics graphics, String string, String string2, int n, boolean bl) {
        if (this.textFont != null && this.guardBars) {
            graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
            this.extraHeight = graphics.getFontMetrics().getHeight() / 2;
        }
        this.paintChar2(graphics, string, string2, n, bl);
        this.extraHeight = 0;
    }

    private String UPCe7To11(String string) {
        if (string.length() == 6) {
            string = "0" + string;
        }
        if (string.length() != 7) {
            string = "0000000";
        }
        int n = Integer.valueOf(string.substring(6, 7));
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        String string4 = string.substring(2, 3);
        String string5 = string.substring(3, 4);
        String string6 = string.substring(4, 5);
        String string7 = string.substring(5, 6);
        String string8 = string.substring(6, 7);
        switch (n) {
            case 0: {
                string = string2 + string3 + string4 + "00000" + string5 + string6 + string7;
                break;
            }
            case 1: {
                string = string2 + string3 + string4 + string8 + "0000" + string5 + string6 + string7;
                break;
            }
            case 2: {
                string = string2 + string3 + string4 + string8 + "0000" + string5 + string6 + string7;
                break;
            }
            case 3: {
                string = string2 + string3 + string4 + string5 + "00000" + string6 + string7;
                break;
            }
            case 4: {
                string = string2 + string3 + string4 + string5 + string6 + "00000" + string7;
                break;
            }
            case 5: {
                string = string2 + string3 + string4 + string5 + string6 + string7 + "0000" + string8;
                break;
            }
            case 6: {
                string = string2 + string3 + string4 + string5 + string6 + string7 + "0000" + string8;
                break;
            }
            case 7: {
                string = string2 + string3 + string4 + string5 + string6 + string7 + "0000" + string8;
                break;
            }
            case 8: {
                string = string2 + string3 + string4 + string5 + string6 + string7 + "0000" + string8;
                break;
            }
            case 9: {
                string = string2 + string3 + string4 + string5 + string6 + string7 + "0000" + string8;
            }
        }
        return string;
    }

    protected void calculateSizes() {
        int n = this.code.length();
        this.narrowBarCM = this.X;
        this.widthBarCM = this.X * this.N;
        if (this.barHeightCM == 0.0) {
            this.barHeightCM = this.L * this.H;
            if (this.barHeightCM < 0.625) {
                this.barHeightCM = 0.625;
            }
        }
        if (this.barHeightCM != 0.0) {
            this.barHeightPixels = (int)(this.barHeightCM * (double)this.resolution);
        }
        if (this.narrowBarCM != 0.0) {
            this.narrowBarPixels = (int)(this.narrowBarCM * (double)this.resolution);
        }
        if (this.widthBarCM != 0.0) {
            this.widthBarPixels = (int)((double)this.narrowBarPixels * this.N);
        }
        if (this.narrowBarPixels <= 0) {
            this.narrowBarPixels = 1;
        }
        if (this.widthBarPixels <= 1) {
            this.widthBarPixels = 2;
        }
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        Image image = null;
        this.textMarginPixels = (int)(this.textMarginCM * (double)this.resolution);
        graphics2.setFont(new Font("Arial", 0, 11));
        int n = graphics2.getFontMetrics().getHeight();
        graphics2.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        int n2 = graphics2.getFontMetrics().getHeight();
        if (this.rotate != 0) {
            String string = System.getProperty("java.version");
            if (string.indexOf("1.0") == 0 || string.indexOf("1.1") == 0) {
                image = this.createImage(this.getSize().width, this.getSize().height);
                graphics2 = image.getGraphics();
            } else {
                IDAImageCreator iDAImageCreator = new IDAImageCreator();
                image = iDAImageCreator.getImage(this.getSize().width, this.getSize().height);
                graphics2 = iDAImageCreator.getGraphics();
            }
        }
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.paintBasis(graphics2);
        int n3 = 0;
        int n4 = 0;
        if (this.rotate != 0) {
            Image image2;
            n3 = this.pWidth;
            if (!this.showText) {
                this.textMarginPixels = 0;
            }
            n4 = this.currentY + this.topMarginPixels + this.textMarginPixels + n + (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
            if (this.barType == 11 || this.barType == 10 || this.barType == 12 || this.barType == 6) {
                n4 += (int)(this.fBearerBarVert * (double)this.narrowBarPixels);
            }
            if (!this.showText) {
                n4 += (int)(this.fBearerBarVert * (double)this.narrowBarPixels);
            }
            if ((image2 = this.rotate(image, this.rotate, n3, n4)) == null) {
                graphics.drawImage(image, 0, 0, null);
            } else {
                graphics.drawImage(image2, 0, 0, null);
            }
        }
    }

    protected void paintBasis(Graphics graphics) {
        int n;
        if (this.barType == 18) {
            if (this.resolution < 40 && this.X < 0.06) {
                this.setXDimensionCM(0.06);
            }
            if (this.X < 0.0381) {
                this.setXDimensionCM(0.0381);
            }
            if (this.X > 0.0635) {
                this.setXDimensionCM(0.0635);
            }
        }
        this.codeText = "";
        graphics.setFont(new Font("Arial", 0, 11));
        this.demoPixelW = graphics.getFontMetrics().stringWidth("Powered by IDAutomation.com");
        this.calculateSizes();
        int n2 = 0;
        this.topMarginPixels = (int)(this.topMarginCM * (double)this.resolution);
        n2 = this.leftMarginPixels = (int)(this.leftMarginCM * (double)this.resolution);
        this.XdimPixels = (int)(this.X * (double)this.resolution);
        this.WhiteBarIncreasePixels = (int)(this.WhiteBarIncrease * (float)this.resolution);
        graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        int n3 = graphics.getFontMetrics().getHeight();
        graphics.setColor(this.backColor);
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        int n6 = n4;
        if (n5 > n6) {
            n6 = n5;
        }
        graphics.fillRect(0, 0, n6, n6);
        this.endOfCode = 0;
        this.currentX = this.leftMarginPixels;
        if (this.barType == 3) {
            this.paintCODE11(graphics, false);
        }
        if (this.barType == 5) {
            this.paintMSI(graphics, false);
        }
        if (this.barType == 4) {
            this.paintCODABAR(graphics, false);
        }
        if (this.barType == 0) {
            this.paintCODE39(graphics, false);
        }
        if (this.barType == 1) {
            this.paintCODE39Ext(graphics, false);
        }
        if (this.barType == 2) {
            this.paintInterleaved25(graphics, false);
        }
        if (this.barType == 9) {
            this.paintBAR93(graphics, false);
        }
        if (this.barType == 11) {
            this.paintEAN8(graphics, false);
        }
        if (this.barType == 10) {
            this.paintEAN13(graphics, false);
        }
        if (this.barType == 6) {
            this.paintUPCA(graphics, false);
        }
        if (this.barType == 12) {
            this.paintUPCE(graphics, false);
        }
        if (this.barType == 13) {
            this.paintCode128(graphics, false);
        }
        if (this.barType == 14) {
            this.paintBAR93Ext(graphics, false);
        }
        if (this.barType == 7) {
            this.paintIND25(graphics, false);
        }
        if (this.barType == 8) {
            this.paintMAT25(graphics, false);
        }
        if (this.barType == 15) {
            this.paintPOSTNET(graphics, false);
        }
        if (this.barType == 16) {
            this.paintPLANET(graphics, false);
        }
        if (this.barType == 17) {
            this.paintCode128(graphics, false);
        }
        if (this.barType == 18) {
            this.paintONECODE(graphics, false);
        }
        if (this.endOfCode == 0) {
            this.endOfCode = this.currentX;
        }
        this.L = (this.currentX - this.leftMarginPixels) / this.resolution;
        if (this.codeText.length() == 0) {
            this.codeText = this.code;
        }
        int n7 = 0;
        graphics.setFont(new Font("Arial", 0, 11));
        this.demoPixelW = graphics.getFontMetrics().stringWidth("Powered by IDAutomation.com");
        graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        this.codeTextW = graphics.getFontMetrics().stringWidth(this.codeText);
        if (this.barType == 18) {
            this.codeTextW += this.leftMarginPixels;
        }
        int n8 = this.currentX - this.leftMarginPixels;
        n8 += 2 * this.leftMarginPixels;
        n8 += (int)(2.0 * (this.fBearerBarVert * (double)this.narrowBarPixels));
        int n9 = 0;
        if (!this.showText) {
            this.codeTextW = 0;
        }
        int n10 = 0;
        if (this.ValSpliceText > 0) {
            n10 = this.codeText.length() / this.ValSpliceText - 1;
        }
        this.codeTextW += graphics.getFontMetrics().stringWidth(" ") * n10;
        if (this.barType == 18) {
            n = graphics.getFontMetrics().stringWidth(" ");
            if (this.codeText.length() == 31) {
                this.codeTextW += 6 * n;
            }
            if (this.codeText.length() == 29) {
                this.codeTextW += 5 * n;
            }
            if (this.codeText.length() == 25) {
                this.codeTextW += 4 * n;
            }
            if (this.codeText.length() == 20) {
                this.codeTextW += 3 * n;
            }
        }
        if (this.codeTextW >= this.demoPixelW && this.codeTextW >= n8) {
            this.pWidth = this.codeTextW;
        }
        if (this.demoPixelW >= this.codeTextW && this.demoPixelW >= n8) {
            this.pWidth = this.demoPixelW;
        }
        if (n8 >= this.codeTextW && n8 >= this.demoPixelW) {
            this.pWidth = n8;
        }
        this.currentX = this.pWidth / 2 - n8 / 2 + this.leftMarginPixels + (int)(this.fBearerBarVert * (double)this.narrowBarPixels);
        if (this.barType == 18) {
            this.currentX = this.leftMarginPixels;
        }
        n9 = this.pWidth / 2 - this.codeTextW / 2;
        n7 = this.pWidth / 2 - this.demoPixelW / 2;
        this.textMarginPixels = (int)(this.textMarginCM * (double)this.resolution);
        graphics.setFont(new Font("Arial", 0, 11));
        n = graphics.getFontMetrics().getHeight();
        graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        if (this.showText && this.textFont != null) {
            graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
            n3 = graphics.getFontMetrics().getHeight();
            if (this.rotate == 0 || this.rotate == 180) {
                this.pHeight = this.barHeightPixels + n3 + this.topMarginPixels * 2 + this.textMarginPixels + n + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
                if (this.barType == 15 || this.barType == 16) {
                    this.pHeight = (int)(this.postnetHeightTallBar * (double)this.resolution) + n3 + n + this.topMarginPixels * 2 + this.textMarginPixels;
                }
            } else {
                this.pHeight = this.barHeightPixels + n3 + this.topMarginPixels * 2 + this.textMarginPixels + n + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
                if (this.barType == 15 || this.barType == 16) {
                    this.pHeight = (int)(this.postnetHeightTallBar * (double)this.resolution) + n3 + n + this.topMarginPixels * 2 + this.textMarginPixels;
                }
            }
        } else if (this.rotate == 0 || this.rotate == 180) {
            this.pHeight = this.barType == 11 || this.barType == 10 || this.barType == 12 || this.barType == 6 ? this.barHeightPixels + this.topMarginPixels * 2 + n + this.textMarginPixels + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels) : this.barHeightPixels + this.topMarginPixels * 2 + n + this.textMarginPixels + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
            if (this.barType == 15 || this.barType == 16) {
                this.pHeight = (int)(this.postnetHeightTallBar * (double)this.resolution) + n + 5 + this.topMarginPixels * 2;
            }
        } else {
            this.pHeight = this.barType == 11 || this.barType == 10 || this.barType == 12 || this.barType == 6 ? this.barHeightPixels + this.topMarginPixels * 2 + n + this.textMarginPixels + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels) : this.barHeightPixels + this.topMarginPixels * 2 + n + this.textMarginPixels + 2 * (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
            if (this.barType == 15 || this.barType == 16) {
                this.pHeight = (int)(this.postnetHeightTallBar * (double)this.resolution) + n + 5 + this.topMarginPixels * 2;
            }
        }
        int n11 = 7;
        int n12 = this.currentX;
        if (this.barType == 3) {
            this.paintCODE11(graphics, true);
        }
        if (this.barType == 5) {
            this.paintMSI(graphics, true);
        }
        if (this.barType == 4) {
            this.paintCODABAR(graphics, true);
        }
        if (this.barType == 0) {
            this.paintCODE39(graphics, true);
        }
        if (this.barType == 1) {
            this.paintCODE39Ext(graphics, true);
        }
        if (this.barType == 2) {
            this.paintInterleaved25(graphics, true);
        }
        if (this.barType == 9) {
            this.paintBAR93(graphics, true);
        }
        if (this.barType == 11) {
            this.paintEAN8(graphics, true);
        }
        if (this.barType == 10) {
            this.paintEAN13(graphics, true);
        }
        if (this.barType == 6) {
            this.paintUPCA(graphics, true);
        }
        if (this.barType == 12) {
            this.paintUPCE(graphics, true);
        }
        if (this.barType == 13) {
            this.paintCode128(graphics, true);
        }
        if (this.barType == 14) {
            this.paintBAR93Ext(graphics, true);
        }
        if (this.barType == 7) {
            this.paintIND25(graphics, true);
        }
        if (this.barType == 8) {
            this.paintMAT25(graphics, true);
        }
        if (this.barType == 15) {
            this.paintPOSTNET(graphics, true);
        }
        if (this.barType == 16) {
            this.paintPLANET(graphics, true);
        }
        if (this.barType == 17) {
            this.paintCode128(graphics, true);
        }
        if (this.barType == 18) {
            this.paintONECODE(graphics, true);
        }
        if (this.endOfCode == 0) {
            this.endOfCode = this.currentX;
        }
        this.currentY = this.barHeightPixels + this.topMarginPixels;
        if (this.autoSize) {
            if (this.rotate == 0 || this.rotate == 180) {
                this.setSize(this.pWidth, this.pHeight);
            } else {
                this.setSize(this.pHeight, this.pWidth);
            }
        }
        if (this.barType == 15 || this.barType == 16) {
            this.currentY = (int)(this.postnetHeightTallBar * (double)this.resolution) + 1 + this.topMarginPixels;
        }
        graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        n3 = graphics.getFontMetrics().getHeight();
        this.codeTextW = graphics.getFontMetrics().stringWidth(this.codeText);
        n = graphics.getFontMetrics().getHeight();
        n11 += n3;
        if (this.showText && this.textFont != null) {
            int n13;
            graphics.setColor(this.fontColor);
            n3 = graphics.getFontMetrics().getHeight();
            int n14 = graphics.getFontMetrics().stringWidth("X");
            if ((this.UPCEANSupplement2 || this.UPCEANSupplement5) && (this.barType == 11 || this.barType == 6 || this.barType == 12 || this.barType == 10)) {
                n13 = (this.endSuplement - this.startSuplement - graphics.getFontMetrics().stringWidth(this.codeSup)) / 2;
                if (n13 < 0) {
                    n13 = 0;
                }
                graphics.drawString(this.codeSup, this.startSuplement + n13, this.topMarginPixels + this.suplementTopMargin - 2);
            }
            n13 = 0;
            if (this.ValSpliceText == 3) {
                this.codeText = this.spliceText(this.codeText, 3);
            }
            if (this.ValSpliceText == 4) {
                this.codeText = this.spliceText(this.codeText, 4);
            }
            if (this.ValSpliceText == 5) {
                this.codeText = this.spliceText(this.codeText, 5);
            }
            if (this.barType == 18) {
                int n15 = 0;
                if (n15 < 0) {
                    n15 = 0;
                }
                n9 = this.leftMarginPixels;
                graphics.drawString(this.codeText, n9, (int)((double)((int)(0.5 * (double)n3)) + this.postnetHeightShortBar * (double)this.resolution * 3.0 + (double)this.textMarginPixels + (double)this.topMarginPixels));
                this.currentY = (int)(this.postnetHeightTallBar * (double)this.resolution) + n3 + 1 + this.topMarginPixels;
                this.DemoDraw(graphics, n7, n11 + 5, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            if (this.barType == 15 || this.barType == 16) {
                int n16 = (this.endOfCode - this.leftMarginPixels - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
                if (n16 < 0) {
                    n16 = 0;
                }
                graphics.drawString(this.codeText, n9, (int)(this.postnetHeightTallBar * (double)this.resolution + (double)((int)(0.5 * (double)n3)) + (double)this.textMarginPixels + (double)this.topMarginPixels));
                this.currentY = (int)(this.postnetHeightTallBar * (double)this.resolution) + n3 + 1 + this.topMarginPixels;
                this.DemoDraw(graphics, n7, n11, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            if (this.barType == 10 && this.guardBars && this.codeText.length() >= 13) {
                int n17 = 0;
                if (this.codeText == "Incorrect Data To Encode") {
                    graphics.drawString(this.codeText, n9, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                } else {
                    graphics.drawString(this.codeText.substring(0, 1), n12 - n14, this.barHeightPixels + this.textMarginPixels + this.topMarginPixels);
                    n17 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 7))) / 2;
                    if (n17 < 0) {
                        n17 = 0;
                    }
                    graphics.drawString(this.codeText.substring(1, 7), this.leftGuardBar + n17, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    n17 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(7, 13))) / 2;
                    if (n17 < 0) {
                        n17 = 0;
                    }
                    graphics.drawString(this.codeText.substring(7, 13), this.centerGuardBarEnd + n17, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    this.currentY = this.barHeightPixels + n3 + 1 + this.topMarginPixels;
                }
                this.DemoDraw(graphics, n7, n11, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            if (this.barType == 6 && this.guardBars && this.codeText.length() >= 12) {
                int n18 = 0;
                if (this.codeText == "Incorrect Data To Encode") {
                    graphics.drawString(this.codeText, n9, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                } else {
                    graphics.drawString(this.codeText.substring(0, 1), n12 - n14, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    n18 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 6))) / 2;
                    if (n18 < 0) {
                        n18 = 0;
                    }
                    graphics.drawString(this.codeText.substring(1, 6), this.leftGuardBar + n18, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    n18 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(6, 11))) / 2;
                    if (n18 < 0) {
                        n18 = 0;
                    }
                    graphics.drawString(this.codeText.substring(6, 11), this.centerGuardBarEnd + n18, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    graphics.drawString(this.codeText.substring(11, 12), this.endOfCode + 3, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    this.currentY = this.barHeightPixels + n3 + 1 + this.topMarginPixels;
                }
                this.DemoDraw(graphics, n7, n11, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            if (this.barType == 11 && this.guardBars && this.codeText.length() >= 8) {
                int n19 = 0;
                if (this.codeText == "Incorrect Data To Encode") {
                    graphics.drawString(this.codeText, n9, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                } else {
                    n19 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(0, 4))) / 2;
                    if (n19 < 0) {
                        n19 = 0;
                    }
                    graphics.drawString(this.codeText.substring(0, 4), this.leftGuardBar + n19, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    n19 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(4, 8))) / 2;
                    if (n19 < 0) {
                        n19 = 0;
                    }
                    graphics.drawString(this.codeText.substring(4, 8), this.centerGuardBarEnd + n19, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    this.currentY = this.barHeightPixels + n3 + 1 + this.topMarginPixels;
                }
                this.DemoDraw(graphics, n7, n11, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            if (this.barType == 12 && this.guardBars && this.codeText.length() >= 8) {
                int n20 = 0;
                if (this.codeText == "Incorrect Data To Encode") {
                    graphics.drawString(this.codeText, n9, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                } else {
                    graphics.drawString(this.codeText.substring(0, 1), n12 - n14, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    n20 = (this.rightGuardBar + 2 - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 7))) / 2;
                    if (n20 < 0) {
                        n20 = 0;
                    }
                    graphics.drawString(this.codeText.substring(1, 7), this.leftGuardBar + n20, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    graphics.drawString(this.codeText.substring(7, 8), this.endOfCode + 2, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
                    this.currentY = this.barHeightPixels + n3 + 1 + this.topMarginPixels;
                }
                this.DemoDraw(graphics, n7, n11, n3);
                this.DrawBearerBars(graphics, 0, n8);
                return;
            }
            int n21 = (this.endOfCode - this.leftMarginPixels - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
            if (this.codeText == "Incorrect Data To Encode") {
                graphics.drawString(this.codeText, n9, this.barHeightPixels + this.textMarginPixels + n13 + this.topMarginPixels);
            } else {
                if (n21 < 0) {
                    n21 = 0;
                }
                graphics.drawString(this.codeText, n9, this.barHeightPixels + (int)(0.5 * (double)n3) + this.textMarginPixels + this.topMarginPixels + (int)(this.fBearerBarHori * (double)this.narrowBarPixels));
                this.currentY = this.barHeightPixels + n3 + 1 + this.topMarginPixels + (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
            }
        }
        this.DemoDraw(graphics, n7, n11 + (int)(this.fBearerBarHori * (double)this.narrowBarPixels), n3);
        this.DrawBearerBars(graphics, 0, n8);
    }

    protected Image rotate(Image image, int n, int n2, int n3) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n5, nArray, 0, n4);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if (n == 90) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    nArray2[n3 * (n2 - (n6 + 1)) + n7] = nArray[n7 * n4 + n6];
                    ++n7;
                }
                ++n6;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, nArray2, 0, n3));
        }
        if (n == 180) {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n3) {
                    nArray2[(n3 - (n9 + 1)) * n2 + (n2 - (n8 + 1))] = nArray[n9 * n4 + n8];
                    ++n9;
                }
                ++n8;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray2, 0, n2));
        }
        if (n == 270) {
            int n10 = 0;
            while (n10 < n2) {
                int n11 = 0;
                while (n11 < n3) {
                    nArray2[n3 * n10 + (n3 - (n11 + 1))] = nArray[n11 * n4 + n10];
                    ++n11;
                }
                ++n10;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, nArray2, 0, n3));
        }
        return null;
    }

    protected String spliceText(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c > '\u001f' && c < '\u0080') {
                stringBuffer = stringBuffer.append(string.charAt(n3));
                ++n2;
            }
            if (n2 % n == 0) {
                stringBuffer = stringBuffer.append(" ");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected void DrawBearerBars(Graphics graphics, int n, int n2) {
        if (this.barType == 15 || this.barType == 16 || this.barType == 18) {
            this.fBearerBarHori = 0.0;
            this.fBearerBarVert = 0.0;
            this.PropBearerBarHori = 0.0;
            this.PropBearerBarVert = 0.0;
        }
        int n3 = (int)(this.fBearerBarVert * (double)this.narrowBarPixels);
        int n4 = (int)(this.fBearerBarHori * (double)this.narrowBarPixels);
        int n5 = 0;
        int n6 = this.currentX + this.leftMarginPixels + n3;
        graphics.setColor(this.barColor);
        if (this.barType == 11 || this.barType == 10 || this.barType == 12 || this.barType == 6) {
            n5 = graphics.getFontMetrics().getHeight();
        }
        if (this.fBearerBarVert > 0.0) {
            if (this.leftMarginCM < 10.0 * this.X) {
                this.leftMarginCM = 10.0 * this.X;
            }
            graphics.fillRect(this.currentX + this.leftMarginPixels, this.topMarginPixels, n3, this.barHeightPixels + this.extraHeight + n5);
            graphics.fillRect(this.currentX + this.leftMarginPixels + n3 - n2, this.topMarginPixels, n3, this.barHeightPixels + this.extraHeight + n5);
        }
        if (this.fBearerBarHori > 0.0) {
            graphics.fillRect(this.currentX + this.leftMarginPixels + n3 - n2, this.topMarginPixels, n2, n4);
            graphics.fillRect(this.currentX + this.leftMarginPixels + n3 - n2, this.topMarginPixels + this.barHeightPixels + n5, n2, n4);
        }
    }

    protected void DemoDraw(Graphics graphics, int n, int n2, int n3) {
        graphics.setFont(new Font("Arial", 0, 11));
        graphics.setColor(Color.decode("#999999"));
        if (this.barType == 15 || this.barType == 16) {
            if (this.showText) {
                graphics.drawString("Powered by IDAutomation.com", n, (int)(this.postnetHeightTallBar * (double)this.resolution) + n2 + this.textMarginPixels + this.topMarginPixels);
            } else {
                graphics.drawString("Powered by IDAutomation.com", n, (int)(this.postnetHeightTallBar * (double)this.resolution) + n2 + this.topMarginPixels);
            }
        } else if (this.showText) {
            graphics.drawString("Powered by IDAutomation.com", n, this.barHeightPixels + this.textMarginPixels + n2 + this.topMarginPixels);
        } else if (this.barType == 11 || this.barType == 10 || this.barType == 12 || this.barType == 6) {
            graphics.drawString("Powered by IDAutomation.com", n, this.barHeightPixels + this.textMarginPixels + n2 + this.topMarginPixels);
        } else {
            graphics.drawString("Powered by IDAutomation.com", n, this.barHeightPixels + this.textMarginPixels - n3 + n2 + this.topMarginPixels);
        }
        graphics.setFont(new Font(this.textFont.getName(), this.textFont.getStyle(), (int)((double)(this.textFont.getSize() * this.resolution) * 0.027)));
        graphics.setColor(this.fontColor);
    }

    static boolean MultiplyBytesByShort(int[] nArray, int n, int n2) {
        int n3;
        if (nArray == null) {
            return false;
        }
        if (n < 1) {
            return false;
        }
        int n4 = 0;
        int n5 = n - 1;
        while (n5 > 0) {
            n3 = nArray[n5];
            n3 |= nArray[n5 - 1] << 8;
            n3 *= n2;
            nArray[n5] = (n3 += n4) & 0xFF;
            nArray[n5 - 1] = n3 >> 8 & 0xFF;
            n4 = n3 >> 16;
            n5 -= 2;
        }
        if (n5 == 0) {
            n3 = nArray[0];
            n3 *= n2;
            nArray[0] = (n3 += n4) & 0xFF;
        }
        return true;
    }

    static boolean AddShortToBytes(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return false;
        }
        if (n < 1) {
            return false;
        }
        int n3 = nArray[n - 1];
        n3 |= nArray[n - 2] << 8;
        nArray[n - 1] = (n3 += n2) & 0xFF;
        nArray[n - 2] = n3 >> 8 & 0xFF;
        int n4 = n3 | 0xFFFF;
        int n5 = n - 3;
        while (n4 == 1 && n5 > 0) {
            n3 = n4 + nArray[n5];
            nArray[n5] = n3 & 0xFF;
            n4 = n3 | 0xFF;
            --n5;
        }
        return true;
    }

    static int GenerateCRC11FrameCheckSequence(int[] nArray) {
        int n = 3893;
        int n2 = 2047;
        int n3 = nArray[0] << 5;
        int n4 = 2;
        while (n4 < 8) {
            n2 = ((n2 ^ n3) & 0x400) != 0 ? n2 << 1 ^ n : (n2 <<= 1);
            n2 &= 0x7FF;
            n3 <<= 1;
            ++n4;
        }
        int n5 = 1;
        while (n5 < 13) {
            n3 = nArray[n5] << 3;
            n4 = 0;
            while (n4 < 8) {
                n2 = ((n2 ^ n3) & 0x400) != 0 ? n2 << 1 ^ n : (n2 <<= 1);
                n2 &= 0x7FF;
                n3 <<= 1;
                ++n4;
            }
            ++n5;
        }
        return n2;
    }

    private boolean GetNof13Table(int n, int[] nArray) {
        switch (n) {
            case 2: {
                if (!Table2of13InitializedFlag && !BarCode.InitializeNof13Table(Table2of13, 2, TABLE_2_OF_13_SIZE)) {
                    return false;
                }
                nArray = Table2of13;
                NumberOf2of13TableEntries = TABLE_2_OF_13_SIZE;
                Table2of13InitializedFlag = true;
                return true;
            }
            case 5: {
                if (!Table5of13InitializedFlag && !BarCode.InitializeNof13Table(Table5of13, 5, TABLE_5_OF_13_SIZE)) {
                    return false;
                }
                nArray = Table5of13;
                NumberOf5of13TableEntries = TABLE_5_OF_13_SIZE;
                Table5of13InitializedFlag = true;
                return true;
            }
        }
        return false;
    }

    static boolean InitializeNof13Table(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n5 < 8192) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < 13) {
                if ((n5 & 1 << n7) != 0) {
                    ++n6;
                }
                ++n7;
            }
            if (n6 == n) {
                boolean bl;
                int n8 = BarCode.ReverseShort(n5) >> 3;
                boolean bl2 = bl = n5 == n8;
                if (n8 >= n5) {
                    if (bl) {
                        nArray[n4] = n5;
                        --n4;
                    } else {
                        nArray[n3] = n5;
                        nArray[++n3] = n8;
                        ++n3;
                    }
                }
            }
            ++n5;
        }
        return n3 == n4 + 1;
    }

    static int ReverseShort(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 16) {
            n2 <<= 1;
            n2 |= n & 1;
            n >>= 1;
            ++n3;
        }
        return n2;
    }

    private boolean ConvertFromBytesToMultiBase(int n, int n2) {
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (!this.DivideBytesByShort(n, (int)CodewordArray[n3][0])) {
                return false;
            }
            BarCode.CodewordArray[n3][1] = Remainder;
            --n3;
        }
        return true;
    }

    private boolean DivideBytesByShort(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.byteArray == null) {
            return false;
        }
        if (n < 2) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        if (n % 2 == 1) {
            n5 = this.byteArray[0];
            n4 = n5 % n2;
            this.byteArray[0] = (byte)(n5 /= n2);
            n3 = 1;
        } else {
            n4 = 0;
            n3 = 0;
        }
        while (n3 < n) {
            n5 = n4 << 16;
            n5 |= this.byteArray[n3] << 8;
            n4 = (n5 |= this.byteArray[n3 + 1]) % n2;
            this.byteArray[n3] = (n5 /= n2) >> 8;
            this.byteArray[n3 + 1] = n5;
            n3 += 2;
        }
        Remainder = (short)n4;
        return true;
    }

    protected void paintONECODE(Graphics graphics, boolean bl) {
        this.setXDimensionCM(0.06);
        StringBuffer stringBuffer = new StringBuffer("");
        Table2of13InitializedFlag = false;
        Table5of13InitializedFlag = false;
        NumberOf5of13TableEntries = 0L;
        NumberOf2of13TableEntries = 0L;
        Remainder = 0;
        Table2of13 = new int[TABLE_2_OF_13_SIZE];
        Table5of13 = new int[TABLE_5_OF_13_SIZE];
        this.byteArray = new int[13];
        int[] nArray = new int[65];
        int[] nArray2 = new int[65];
        double[][] dArray = new double[10][2];
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        if (this.code.length() < 20) {
            this.codeText = "Incorrectly formatted DataToEncode";
            return;
        }
        stringBuffer4.append(this.code.substring(0, 20));
        stringBuffer3.append(this.code.substring(20));
        if (stringBuffer4.length() != 20) {
            System.out.println("Incorrectly formatted tracking number");
            this.codeText = "Incorrectly formed DataToEncode parameter";
            return;
        }
        int n2 = 0;
        while (n2 < stringBuffer3.length()) {
            if (!Character.isDigit(stringBuffer3.charAt(n2))) {
                System.out.println("Incorrectly formatted Routing number");
                this.codeText = "Incorrectly formed DataToEncode parameter";
                return;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringBuffer4.length()) {
            if (!Character.isDigit(stringBuffer4.charAt(n3))) {
                System.out.println("Incorrectly formatted tracking number");
                this.codeText = "Incorrectly formed DataToEncode parameter";
                return;
            }
            ++n3;
        }
        if (Character.getNumericValue(stringBuffer4.charAt(1)) > 4) {
            System.out.println("Incorrectly formatted Barcode Identifier");
            this.codeText = "Incorrectly formed DataToEncode parameter";
            return;
        }
        long l = 0L;
        if (stringBuffer3.length() == 5) {
            l = Integer.valueOf(stringBuffer3.toString()) + 1;
        } else if (stringBuffer3.length() == 9) {
            l = Integer.valueOf(stringBuffer3.toString()) + 100000 + 1;
        } else if (stringBuffer3.length() == 11) {
            l = Integer.valueOf(stringBuffer3.toString()).longValue() + 1000000000L + 100000L + 1L;
        } else if (stringBuffer3.length() > 0) {
            System.out.println("Incorrectly formed DataToEncode parameter");
            this.codeText = "Incorrectly formed DataToEncode parameter";
            return;
        }
        this.byteArray[12] = (int)(l & 0xFFL);
        this.byteArray[11] = (int)(l >> 8 & 0xFFL);
        this.byteArray[10] = (int)(l >> 16 & 0xFFL);
        this.byteArray[9] = (int)(l >> 24 & 0xFFL);
        this.byteArray[8] = (int)(l >> 32 & 0xFFL);
        BarCode.MultiplyBytesByShort(this.byteArray, 13, 10);
        BarCode.AddShortToBytes(this.byteArray, 13, Integer.valueOf(stringBuffer4.substring(0, 1)));
        BarCode.MultiplyBytesByShort(this.byteArray, 13, 5);
        BarCode.AddShortToBytes(this.byteArray, 13, Integer.valueOf(stringBuffer4.substring(1, 2)));
        int n4 = 2;
        while (n4 < 20) {
            BarCode.MultiplyBytesByShort(this.byteArray, 13, 10);
            BarCode.AddShortToBytes(this.byteArray, 13, Integer.valueOf(stringBuffer4.substring(n4, n4 + 1)));
            ++n4;
        }
        n = BarCode.GenerateCRC11FrameCheckSequence(this.byteArray);
        if (!this.GetNof13Table(5, Table5of13ArrayPtr)) {
            System.out.println("Table 5 of 13 retrieve error");
            return;
        }
        if (!this.GetNof13Table(2, Table2of13ArrayPtr)) {
            System.out.println("Table 2 of 13 retrieve error");
            return;
        }
        int n5 = 0;
        while (n5 < 10) {
            BarCode.CodewordArray[n5][0] = NumberOf5of13TableEntries + NumberOf2of13TableEntries;
            BarCode.CodewordArray[n5][1] = 0.0;
            ++n5;
        }
        BarCode.CodewordArray[0][0] = 659.0;
        BarCode.CodewordArray[9][0] = 636.0;
        if (!this.ConvertFromBytesToMultiBase(13, 10)) {
            System.out.println("Codeword conversion failed");
            return;
        }
        if (CodewordArray[0][1] >= 659.0) {
            System.out.println("Codeword conversion failed1");
            return;
        }
        if (CodewordArray[9][1] >= 636.0) {
            System.out.println("Codeword conversion failed2");
            return;
        }
        BarCode.CodewordArray[9][1] = CodewordArray[9][1] * 2.0;
        if (n >> 10 != 0) {
            double[] dArray2 = CodewordArray[0];
            dArray2[1] = dArray2[1] + 659.0;
        }
        int n6 = 0;
        while (n6 < 10) {
            if (CodewordArray[n6][1] >= (double)(NumberOf5of13TableEntries + NumberOf2of13TableEntries)) {
                System.out.println("Character Range Error");
                return;
            }
            if (CodewordArray[n6][1] >= (double)NumberOf5of13TableEntries) {
                dArray[n6][0] = 8192.0;
                dArray[n6][1] = Table2of13[(int)(CodewordArray[n6][1] - (double)NumberOf5of13TableEntries)];
            } else {
                dArray[n6][0] = 8192.0;
                dArray[n6][1] = Table5of13[(int)CodewordArray[n6][1]];
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < 10) {
            if ((n & 1 << n7) != 0) {
                dArray[n7][1] = ~((int)dArray[n7][1]) & 0x1FFF;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < 65) {
            nArray[n8] = (int)dArray[BarTopCharacterIndexArray[n8]][1] >> BarTopCharacterShiftArray[n8] & 1;
            nArray2[n8] = (int)dArray[BarBottomCharacterIndexArray[n8]][1] >> BarBottomCharacterShiftArray[n8] & 1;
            ++n8;
        }
        int n9 = 0;
        while (n9 < 65) {
            if (nArray[n9] == 0) {
                if (nArray2[n9] == 0) {
                    stringBuffer.append('T');
                } else {
                    stringBuffer.append('D');
                }
            } else if (nArray2[n9] == 0) {
                stringBuffer.append('A');
            } else {
                stringBuffer.append('F');
            }
            ++n9;
        }
        this.codeText = stringBuffer4.toString();
        if (stringBuffer3.length() > 1) {
            this.codeText = this.codeText + stringBuffer3.toString();
        }
        String string = this.codeText;
        if (stringBuffer3.length() == 11) {
            this.codeText = this.codeText.substring(0, 29) + " " + this.codeText.substring(29);
        }
        if (stringBuffer3.length() >= 9) {
            this.codeText = this.codeText.substring(0, 25) + " " + this.codeText.substring(25);
        }
        if (stringBuffer3.length() >= 5) {
            this.codeText = this.codeText.substring(0, 20) + " " + this.codeText.substring(20);
        }
        this.codeText = this.codeText.substring(0, 11) + " " + this.codeText.substring(11);
        this.codeText = this.codeText.substring(0, 5) + " " + this.codeText.substring(5);
        this.codeText = this.codeText.substring(0, 2) + " " + this.codeText.substring(2);
        this.currentX = this.leftMarginPixels;
        boolean bl2 = false;
        int n10 = 0;
        while (n10 <= stringBuffer.length() - 1) {
            int n11 = (int)(this.postnetHeightShortBar * (double)this.resolution);
            int n12 = 3 * n11;
            float f = 0.0f;
            double d = 0.0;
            if (stringBuffer.charAt(n10) == 'F') {
                d = 0.0;
                f = n11 * 3;
            } else if (stringBuffer.charAt(n10) == 'D') {
                d = n11;
                f = n11 * 3;
            } else if (stringBuffer.charAt(n10) == 'A') {
                d = 0.0;
                f = n11 * 2;
            } else if (stringBuffer.charAt(n10) == 'T') {
                d = n11;
                f = n11 * 2;
            }
            this.barHeightPixels = (int)f;
            this.paintChar2(graphics, "bw", "11", (int)d, bl);
            ++n10;
        }
    }
}

