/*
 * Decompiled with CFR 0.152.
 */
package com.idautomation.linear;

import com.idautomation.linear.BarCode;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

public class BCApplet
extends Applet {
    public BarCode BC = null;
    public boolean isStandalone = false;

    public BCApplet() {
        this.setLayout(new BorderLayout());
    }

    public void start() {
        this.BC.autoSize = true;
        this.BC.paint(this.getGraphics());
    }

    public void refresh() {
        this.BC.paint(this.BC.getGraphics());
        this.paintAll(this.getGraphics());
    }

    public void init() {
        if (this.BC == null) {
            this.BC = new BarCode();
        }
        this.add("Center", this.BC);
        this.initParam("CODE_TYPE");
        this.initParam("N");
        this.initParam("X");
        this.initParam("I");
        this.initParam("H");
        this.initParam("BAR_HEIGHT");
        this.initParam("CODABAR_START");
        this.initParam("CODABAR_STOP");
        this.initParam("BAR_COLOR");
        this.initParam("FONT_COLOR");
        this.initParam("TEXT_FONT");
        this.initParam("UPCE_SYSTEM");
        this.initParam("BACK_COLOR");
        this.initParam("CODE128_SET");
        this.initParam("LEFT_MARGIN");
        this.initParam("TOP_MARGIN");
        this.initParam("CHECK_CHAR");
        this.initParam("BARCODE");
        this.initParam("GUARDBARS");
        this.initParam("ROTATE");
        this.initParam("SUPPLEMENT");
        this.initParam("SUPPLEMENT_CODE");
        this.initParam("SUPPLEMENT_HEIGHT");
        this.initParam("SUPPLEMENT_SEPARATION");
        this.initParam("POSTNET_TALL");
        this.initParam("POSTNET_SHORT");
        this.initParam("CHECK_CHARINTEXT");
        this.initParam("ST");
        this.initParam("PT");
        this.initParam("TEXT_MARGIN");
        this.initParam("BEARERBAR_HORIZONTAL");
        this.initParam("BEARERBAR_VERTICAL");
        this.initParam("CHARACTER_GROUPING");
        this.initParam("WHITE_BAR_INCREASE");
    }

    private void initParam(String string) {
        String string2 = this.getStringParam(string, "");
        if (string2.length() == 0) {
            return;
        }
        this.setParameter(string, string2);
    }

    public void setParameter(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.compareTo("CODE_TYPE") == 0) {
            if (string2.compareTo("CODE39") == 0) {
                this.BC.barType = 0;
            }
            if (string2.compareTo("CODE39EXT") == 0) {
                this.BC.barType = 1;
            }
            if (string2.compareTo("CODE93") == 0) {
                this.BC.barType = 9;
            }
            if (string2.compareTo("CODE11") == 0) {
                this.BC.barType = 3;
            }
            if (string2.compareTo("CODABAR") == 0) {
                this.BC.barType = 4;
            }
            if (string2.compareTo("CODE93EXT") == 0) {
                this.BC.barType = 14;
            }
            if (string2.compareTo("CODE128") == 0) {
                this.BC.barType = 13;
            }
            if (string2.compareTo("MSI") == 0) {
                this.BC.barType = 5;
            }
            if (string2.compareTo("IND25") == 0) {
                this.BC.barType = 7;
            }
            if (string2.compareTo("MAT25") == 0) {
                this.BC.barType = 8;
            }
            if (string2.compareTo("INTERLEAVED25") == 0) {
                this.BC.barType = 2;
            }
            if (string2.compareTo("EAN13") == 0) {
                this.BC.barType = 10;
            }
            if (string2.compareTo("EAN8") == 0) {
                this.BC.barType = 11;
            }
            if (string2.compareTo("UPCA") == 0) {
                this.BC.barType = 6;
            }
            if (string2.compareTo("UPCE") == 0) {
                this.BC.barType = 12;
            }
            if (string2.compareTo("POSTNET") == 0) {
                this.BC.barType = 15;
            }
            if (string2.compareTo("PLANET") == 0) {
                this.BC.barType = 16;
            }
            if (string2.compareTo("UCC128") == 0) {
                this.BC.barType = 17;
            }
            if (string2.compareTo("ONECODE") == 0) {
                this.BC.barType = 18;
            }
        }
        if (string.compareTo("N") == 0) {
            this.BC.N = new Double(string2);
        }
        if (string.compareTo("SUPPLEMENT_CODE") == 0) {
            this.BC.supplement = string2;
        }
        if (string.compareTo("SUPPLEMENT_SEPARATION") == 0) {
            this.BC.supSeparationCM = new Double(string2);
        }
        if (string.compareTo("SUPPLEMENT_HEIGHT") == 0) {
            this.BC.supHeight = new Double(string2);
        }
        if (string.compareTo("SUPPLEMENT") == 0) {
            this.BC.UPCEANSupplement2 = false;
            this.BC.UPCEANSupplement5 = false;
            if (string2.compareTo("2") == 0) {
                this.BC.UPCEANSupplement2 = true;
            }
            if (string2.compareTo("5") == 0) {
                this.BC.UPCEANSupplement5 = true;
            }
        }
        if (string.compareTo("ROTATE") == 0) {
            this.BC.setRotationAngle((int)new Double(string2).doubleValue());
        }
        if (string.compareTo("POSTNET_TALL") == 0) {
            this.BC.postnetHeightTallBar = (int)new Double(string2).doubleValue();
        }
        if (string.compareTo("POSTNET_SHORT") == 0) {
            this.BC.postnetHeightShortBar = (int)new Double(string2).doubleValue();
        }
        if (string.compareTo("X") == 0) {
            this.BC.X = new Double(string2);
        }
        if (string.compareTo("I") == 0) {
            this.BC.I = new Double(string2);
        }
        if (string.compareTo("LEFT_MARGIN") == 0) {
            this.BC.leftMarginCM = new Double(string2);
        }
        if (string.compareTo("TOP_MARGIN") == 0) {
            this.BC.topMarginCM = new Double(string2);
        }
        if (string.compareTo("BAR_COLOR") == 0) {
            this.BC.barColor = this.convertColor(string2);
        }
        if (string.compareTo("FONT_COLOR") == 0) {
            this.BC.fontColor = this.convertColor(string2);
        }
        if (string.compareTo("BACK_COLOR") == 0) {
            this.BC.backColor = this.convertColor(string2);
        }
        if (string.compareTo("GUARDBARS") == 0) {
            boolean bl = this.BC.guardBars = string2.compareTo("Y") == 0;
        }
        if (string.compareTo("UPCE_SYSTEM") == 0) {
            this.BC.UPCESytem = new String(string2 + "1").charAt(0);
        }
        if (string.compareTo("CODABAR_START") == 0) {
            this.BC.CODABARStartChar = new String(string2 + "A").charAt(0);
        }
        if (string.compareTo("CODABAR_STOP") == 0) {
            this.BC.CODABARStopChar = new String(string2 + "A").charAt(0);
        }
        if (string.compareTo("TEXT_FONT") == 0) {
            this.BC.textFont = this.convertFont(string2);
        }
        if (string.compareTo("H") == 0) {
            this.BC.H = new Double(string2);
        }
        if (string.compareTo("BARCODE") == 0) {
            this.BC.setDataToEncode(string2);
        }
        if (string.compareTo("CHECK_CHAR") == 0) {
            boolean bl = this.BC.checkCharacter = string2.compareTo("Y") == 0;
        }
        if (string.compareTo("CHECK_CHARINTEXT") == 0) {
            boolean bl = this.BC.checkCharacterInText = string2.compareTo("Y") == 0;
        }
        if (string.compareTo("CODE128_SET") == 0) {
            this.BC.Code128Set = new String(string2 + "B").charAt(0);
        }
        if (string.compareTo("BAR_HEIGHT") == 0) {
            this.BC.barHeightCM = new Double(string2);
        }
        if (string.compareTo("ST") == 0) {
            boolean bl = this.BC.showText = string2.compareTo("Y") == 0;
        }
        if (string.compareTo("PT") == 0) {
            boolean bl = this.BC.processTilde = string2.toUpperCase().compareTo("Y") == 0;
        }
        if (string.compareTo("TEXT_MARGIN") == 0) {
            this.BC.textMarginCM = new Double(string2);
        }
        if (string.compareTo("WHITE_BAR_INCREASE") == 0) {
            this.BC.WhiteBarIncrease = new Float(string2).floatValue();
        }
        if (string.compareTo("BEARERBAR_HORIZONTAL") == 0) {
            this.BC.fBearerBarHori = new Double(string2);
        }
        if (string.compareTo("BEARERBAR_VERTICAL") == 0) {
            this.BC.fBearerBarVert = new Double(string2);
        }
        if (string.compareTo("CHARACTER_GROUPING") == 0) {
            this.BC.ValSpliceText = new Integer(string2);
        }
    }

    public Color convertColor(String string) {
        if (string.compareTo("NULL") == 0) {
            return null;
        }
        if (string.compareTo("RED") == 0) {
            return Color.red;
        }
        if (string.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (string.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (string.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (string.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (string.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (string.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (string.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (string.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (string.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (string.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (string.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (string.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            return Color.black;
        }
    }

    public Font convertFont(String string) {
        String[] stringArray = this.convertList(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length < 3) {
            return null;
        }
        int n = 0;
        if (stringArray[1].compareTo("BOLD") == 0) {
            n = 1;
        }
        if (stringArray[1].compareTo("ITALIC") == 0) {
            n = 2;
        }
        try {
            return new Font(stringArray[0], n, new Integer(stringArray[2]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getStringParam(String string, String string2) {
        return this.getParameter(string, string2);
    }

    private String getParameter(String string, String string2) {
        if (this.isStandalone) {
            return string2;
        }
        if (this.getParameter(string) != null) {
            return this.getParameter(string);
        }
        return string2;
    }

    private String[] convertList(String string) {
        String[] stringArray = new String[500];
        int n = 0;
        int n2 = string.indexOf("|");
        while (n2 >= 0) {
            stringArray[n++] = string.substring(0, n2);
            string = string.substring(n2 + 1, string.length());
            n2 = string.indexOf("|");
        }
        if (string.compareTo("") != 0) {
            stringArray[n++] = string;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray2[n3] = stringArray[n3];
            ++n3;
        }
        return stringArray2;
    }

    private Integer getIntParam(String string, Integer n) {
        try {
            String string2 = this.getParameter(string, "");
            if (string2.compareTo("") == 0) {
                return n;
            }
            return new Integer(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private Double getDoubleParam(String string, Double d) {
        try {
            String string2 = this.getParameter(string, "");
            if (string2.compareTo("") == 0) {
                return d;
            }
            return new Double(string2);
        }
        catch (Exception exception) {
            return d;
        }
    }
}

